/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.packages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.soup.project.datamodel.commons.oracle.ModuleDataModelOracleImpl;
import org.kie.soup.project.datamodel.commons.oracle.PackageDataModelOracleImpl;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.oracle.ExtensionKind;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.GlobalsParser;
import org.uberfire.commons.data.Pair;

public final class PackageDataModelOracleBuilder {
    private final String packageName;
    private PackageDataModelOracleImpl packageOracle = new PackageDataModelOracleImpl();
    private ModuleDataModelOracle moduleOracle = new ModuleDataModelOracleImpl();
    private Map<String, String[]> factFieldEnums = new HashMap<String, String[]>();
    private Map<ExtensionKind<?>, List<?>> extensions = new HashMap();
    private Map<String, String> packageGlobalTypes = new HashMap<String, String>();
    private MVELEvaluator evaluator;

    public static PackageDataModelOracleBuilder newPackageOracleBuilder(MVELEvaluator evaluator) {
        return new PackageDataModelOracleBuilder("", evaluator);
    }

    public static PackageDataModelOracleBuilder newPackageOracleBuilder(MVELEvaluator evaluator, String packageName) {
        return new PackageDataModelOracleBuilder(packageName, evaluator);
    }

    private PackageDataModelOracleBuilder(String packageName, MVELEvaluator evaluator) {
        this.packageName = packageName;
        this.evaluator = evaluator;
    }

    public PackageDataModelOracleBuilder setModuleOracle(ModuleDataModelOracle moduleOracle) {
        this.moduleOracle = moduleOracle;
        return this;
    }

    public PackageDataModelOracleBuilder addEnum(String factType, String fieldName, String[] values) {
        String qualifiedFactField = factType + "#" + fieldName;
        this.factFieldEnums.put(qualifiedFactField, values);
        return this;
    }

    public PackageDataModelOracleBuilder addEnum(String enumDefinition, ClassLoader classLoader) {
        this.parseEnumDefinition(enumDefinition, classLoader, this.evaluator);
        return this;
    }

    private void parseEnumDefinition(String enumDefinition, ClassLoader classLoader, MVELEvaluator evaluator) {
        DataEnumLoader enumLoader = new DataEnumLoader(enumDefinition, classLoader, evaluator);
        if (!enumLoader.hasErrors()) {
            this.factFieldEnums.putAll(enumLoader.getData());
        }
    }

    public PackageDataModelOracleBuilder addGlobals(String definition) {
        List<Pair<String, String>> globals = GlobalsParser.parseGlobals(definition);
        for (Pair<String, String> g : globals) {
            this.packageGlobalTypes.put((String)g.getK1(), (String)g.getK2());
        }
        return this;
    }

    public PackageDataModelOracle build() {
        ModuleDataModelOracleImpl pd = (ModuleDataModelOracleImpl)this.moduleOracle;
        this.packageOracle.addModuleModelFields(pd.getModuleModelFields());
        this.packageOracle.addModuleFieldParametersType(pd.getModuleFieldParametersType());
        this.packageOracle.addModuleJavaEnumDefinitions(pd.getModuleJavaEnumDefinitions());
        this.packageOracle.addModuleMethodInformation(pd.getModuleMethodInformation());
        this.packageOracle.addModuleCollectionTypes(pd.getModuleCollectionTypes());
        this.packageOracle.addModuleEventTypes(pd.getModuleEventTypes());
        this.packageOracle.addModuleTypeSources(pd.getModuleTypeSources());
        this.packageOracle.addModuleSuperTypes(pd.getModuleSuperTypes());
        this.packageOracle.addModuleTypeAnnotations(pd.getModuleTypeAnnotations());
        this.packageOracle.addModuleTypeFieldsAnnotations(pd.getModuleTypeFieldsAnnotations());
        this.packageOracle.addModulePackageNames(pd.getModulePackageNames());
        this.loadEnums();
        this.loadPackageElements();
        this.loadGlobals();
        this.loadModuleOracle();
        return this.packageOracle;
    }

    private void loadModuleOracle() {
        this.packageOracle.setPackageName(this.packageName);
    }

    private void loadEnums() {
        HashMap<String, String[]> loadableEnums = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> e : this.factFieldEnums.entrySet()) {
            String qualifiedFactField = e.getKey();
            loadableEnums.put(qualifiedFactField, e.getValue());
        }
        this.packageOracle.addPackageWorkbenchEnumDefinitions(loadableEnums);
    }

    private void loadPackageElements() {
        this.packageOracle.addExtensions(this.extensions);
    }

    private void loadGlobals() {
        this.packageOracle.addPackageGlobals(this.packageGlobalTypes);
    }

    public PackageDataModelOracleBuilder addExtension(ExtensionKind<?> kind, List<?> values) {
        List list = this.extensions.computeIfAbsent(kind, k -> new ArrayList());
        list.addAll(values);
        return this;
    }
}

