/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.server.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.designer.server.diagram.Bounds;
import org.jbpm.designer.server.diagram.Diagram;
import org.jbpm.designer.server.diagram.Point;
import org.jbpm.designer.server.diagram.Shape;
import org.jbpm.designer.server.diagram.StencilSet;
import org.jbpm.designer.server.diagram.StencilType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DiagramBuilder {
    private static final String jsonPattern = "glossary://(.*?)/([\\w\\W]*?)(;;)";

    public static Diagram parseJson(String json) throws JSONException {
        return DiagramBuilder.parseJson(json, (Boolean)false);
    }

    public static Diagram parseJson(String json, Boolean keepGlossaryLink) throws JSONException {
        JSONObject modelJSON = new JSONObject(json);
        return DiagramBuilder.parseJson(modelJSON, keepGlossaryLink);
    }

    public static Diagram parseJson(JSONObject json) throws JSONException {
        return DiagramBuilder.parseJson(json, (Boolean)false);
    }

    public static Diagram parseJson(JSONObject json, Boolean keepGlossaryLink) throws JSONException {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        HashMap<String, JSONObject> flatJSON = DiagramBuilder.flatRessources(json);
        for (String resourceId : flatJSON.keySet()) {
            DiagramBuilder.parseRessource(shapes, flatJSON, resourceId, keepGlossaryLink);
        }
        String id = "canvas";
        if (json.has("resourceId")) {
            id = json.getString("resourceId");
            shapes.remove(new Shape(id));
        }
        Diagram diagram = new Diagram(id);
        DiagramBuilder.parseStencilSet(json, diagram);
        DiagramBuilder.parseSsextensions(json, diagram);
        DiagramBuilder.parseStencil(json, diagram);
        DiagramBuilder.parseProperties(json, diagram, keepGlossaryLink);
        DiagramBuilder.parseChildShapes(shapes, json, diagram);
        DiagramBuilder.parseBounds(json, diagram);
        diagram.setShapes(shapes);
        return diagram;
    }

    private static void parseRessource(ArrayList<Shape> shapes, HashMap<String, JSONObject> flatJSON, String resourceId, Boolean keepGlossaryLink) throws JSONException {
        JSONObject modelJSON = flatJSON.get(resourceId);
        Shape current = DiagramBuilder.getShapeWithId(modelJSON.getString("resourceId"), shapes);
        DiagramBuilder.parseStencil(modelJSON, current);
        DiagramBuilder.parseProperties(modelJSON, current, keepGlossaryLink);
        DiagramBuilder.parseOutgoings(shapes, modelJSON, current);
        DiagramBuilder.parseChildShapes(shapes, modelJSON, current);
        DiagramBuilder.parseDockers(modelJSON, current);
        DiagramBuilder.parseBounds(modelJSON, current);
        DiagramBuilder.parseTarget(shapes, modelJSON, current);
    }

    private static void parseStencil(JSONObject modelJSON, Shape current) throws JSONException {
        if (modelJSON.has("stencil")) {
            JSONObject stencil = modelJSON.getJSONObject("stencil");
            String stencilString = "";
            if (stencil.has("id")) {
                stencilString = stencil.getString("id");
            }
            current.setStencil(new StencilType(stencilString));
        }
    }

    private static void parseStencilSet(JSONObject modelJSON, Diagram current) throws JSONException {
        if (modelJSON.has("stencilset")) {
            JSONObject object = modelJSON.getJSONObject("stencilset");
            String url = null;
            String namespace = null;
            if (object.has("url")) {
                url = object.getString("url");
            }
            if (object.has("namespace")) {
                namespace = object.getString("namespace");
            }
            current.setStencilset(new StencilSet(url, namespace));
        }
    }

    private static void parseProperties(JSONObject modelJSON, Shape current, Boolean keepGlossaryLink) throws JSONException {
        if (modelJSON.has("properties")) {
            JSONObject propsObject = modelJSON.getJSONObject("properties");
            Iterator keys = propsObject.keys();
            Pattern pattern = Pattern.compile(jsonPattern);
            while (keys.hasNext()) {
                StringBuilder result = new StringBuilder();
                int lastIndex = 0;
                String key = (String)keys.next();
                String value = propsObject.getString(key);
                if (!keepGlossaryLink.booleanValue()) {
                    Matcher matcher = pattern.matcher(value);
                    while (matcher.find()) {
                        String id = matcher.group(1);
                        current.addGlossaryIds(id);
                        String text = matcher.group(2);
                        result.append(text);
                        lastIndex = matcher.end();
                    }
                    result.append(value.substring(lastIndex));
                    value = result.toString();
                }
                current.putProperty(key, value);
            }
        }
    }

    private static void parseSsextensions(JSONObject modelJSON, Diagram current) throws JSONException {
        if (modelJSON.has("ssextensions")) {
            JSONArray array = modelJSON.getJSONArray("ssextensions");
            for (int i = 0; i < array.length(); ++i) {
                current.addSsextension(array.getString(i));
            }
        }
    }

    private static void parseOutgoings(ArrayList<Shape> shapes, JSONObject modelJSON, Shape current) throws JSONException {
        if (modelJSON.has("outgoing")) {
            ArrayList<Shape> outgoings = new ArrayList<Shape>();
            JSONArray outgoingObject = modelJSON.getJSONArray("outgoing");
            for (int i = 0; i < outgoingObject.length(); ++i) {
                Shape out = DiagramBuilder.getShapeWithId(outgoingObject.getJSONObject(i).getString("resourceId"), shapes);
                outgoings.add(out);
                out.addIncoming(current);
            }
            if (outgoings.size() > 0) {
                current.setOutgoings(outgoings);
            }
        }
    }

    private static void parseChildShapes(ArrayList<Shape> shapes, JSONObject modelJSON, Shape current) throws JSONException {
        if (modelJSON.has("childShapes")) {
            ArrayList<Shape> childShapes = new ArrayList<Shape>();
            JSONArray childShapeObject = modelJSON.getJSONArray("childShapes");
            for (int i = 0; i < childShapeObject.length(); ++i) {
                childShapes.add(DiagramBuilder.getShapeWithId(childShapeObject.getJSONObject(i).getString("resourceId"), shapes));
            }
            if (childShapes.size() > 0) {
                for (Shape each : childShapes) {
                    each.setParent(current);
                }
                current.setChildShapes(childShapes);
            }
        }
    }

    private static void parseDockers(JSONObject modelJSON, Shape current) throws JSONException {
        if (modelJSON.has("dockers")) {
            ArrayList<Point> dockers = new ArrayList<Point>();
            JSONArray dockersObject = modelJSON.getJSONArray("dockers");
            for (int i = 0; i < dockersObject.length(); ++i) {
                Double x = dockersObject.getJSONObject(i).getDouble("x");
                Double y = dockersObject.getJSONObject(i).getDouble("y");
                dockers.add(new Point(x, y));
            }
            if (dockers.size() > 0) {
                current.setDockers(dockers);
            }
        }
    }

    private static void parseBounds(JSONObject modelJSON, Shape current) throws JSONException {
        if (modelJSON.has("bounds")) {
            JSONObject boundsObject = modelJSON.getJSONObject("bounds");
            current.setBounds(new Bounds(new Point(boundsObject.getJSONObject("lowerRight").getDouble("x"), boundsObject.getJSONObject("lowerRight").getDouble("y")), new Point(boundsObject.getJSONObject("upperLeft").getDouble("x"), boundsObject.getJSONObject("upperLeft").getDouble("y"))));
        }
    }

    private static void parseTarget(ArrayList<Shape> shapes, JSONObject modelJSON, Shape current) throws JSONException {
        JSONObject targetObject;
        if (modelJSON.has("target") && (targetObject = modelJSON.getJSONObject("target")).has("resourceId")) {
            current.setTarget(DiagramBuilder.getShapeWithId(targetObject.getString("resourceId"), shapes));
        }
    }

    private static Shape getShapeWithId(String id, ArrayList<Shape> shapes) {
        Shape result = new Shape(id);
        if (shapes.contains(result)) {
            return shapes.get(shapes.indexOf(result));
        }
        shapes.add(result);
        return result;
    }

    public static HashMap<String, JSONObject> flatRessources(JSONObject object) throws JSONException {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        if (object.has("resourceId") && object.has("childShapes")) {
            result.put(object.getString("resourceId"), object);
            JSONArray childShapes = object.getJSONArray("childShapes");
            for (int i = 0; i < childShapes.length(); ++i) {
                result.putAll(DiagramBuilder.flatRessources(childShapes.getJSONObject(i)));
            }
        }
        return result;
    }
}

