/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.adf.engine.shared.formGeneration;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.kie.workbench.common.forms.adf.engine.shared.FormElementFilter;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.I18nHelper;
import org.kie.workbench.common.forms.adf.service.building.FieldStatusModifier;
import org.kie.workbench.common.forms.adf.service.definitions.FormDefinitionSettings;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.model.impl.PortableJavaModel;

public class FormGenerationContext {
    private FormDefinition formDefinition;
    private FormDefinitionSettings formDefinitionSettings;
    private Map<String, String> fieldStatusModifierReferences = new HashMap<String, String>();
    private Map<String, FieldStatusModifier> fieldStatusModifiers = new HashMap<String, FieldStatusModifier>();
    private Map<String, FormElementFilter> filters = new HashMap<String, FormElementFilter>();
    private I18nHelper i18nHelper;
    private Object model;

    public FormGenerationContext(Object model, FormDefinitionSettings settings, I18nHelper i18nHelper, FormElementFilter ... filters) {
        this.model = model;
        this.formDefinitionSettings = settings;
        this.i18nHelper = i18nHelper;
        this.formDefinition = new FormDefinition((FormModel)new PortableJavaModel(settings.getModelType()));
        this.formDefinition.setName(settings.getModelType());
        this.formDefinition.setId(settings.getModelType());
        Stream.of(filters).forEach(filter -> this.filters.put(filter.getElementName(), (FormElementFilter)filter));
    }

    public FormDefinition getFormDefinition() {
        return this.formDefinition;
    }

    public FormDefinitionSettings getFormDefinitionSettings() {
        return this.formDefinitionSettings;
    }

    public I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    public void setFieldStatusModifierReferences(Map<String, String> fieldStatusModifierReferences) {
        this.fieldStatusModifierReferences = fieldStatusModifierReferences;
    }

    public void setFieldStatusModifiers(Map<String, FieldStatusModifier> fieldStatusModifiers) {
        this.fieldStatusModifiers = fieldStatusModifiers;
    }

    public FieldStatusModifier getStatusModifierForFieldName(String fieldName) {
        String modifierName = this.fieldStatusModifierReferences.get(fieldName);
        if (modifierName != null) {
            return this.fieldStatusModifiers.get(modifierName);
        }
        return null;
    }

    public FormElementFilter getFilter(String elementName) {
        return this.filters.get(elementName);
    }

    public Object getModel() {
        return this.model;
    }
}

