/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Stack;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.security.SecurityAdapter;

public abstract class BaseIdentityProvider
implements IdentityProvider {
    protected Stack<String> contextUsers;
    protected static final ServiceLoader<SecurityAdapter> securityAdapters = ServiceLoader.load(SecurityAdapter.class);
    protected List<SecurityAdapter> adapters = new ArrayList<SecurityAdapter>();

    public BaseIdentityProvider() {
        for (SecurityAdapter adapter : securityAdapters) {
            this.adapters.add(adapter);
        }
        this.contextUsers = new Stack();
    }

    public void setContextIdentity(String userId) {
        this.contextUsers.push(userId);
    }

    public void removeContextIdentity() {
        this.contextUsers.pop();
    }

    protected String getNameFromAdapter() {
        for (SecurityAdapter adapter : this.adapters) {
            String name = adapter.getUser(new Object[0]);
            if (name == null || name.isEmpty()) continue;
            return name;
        }
        return "unknown";
    }

    protected List<String> getRolesFromAdapter() {
        ArrayList<String> roles = new ArrayList<String>();
        for (SecurityAdapter adapter : this.adapters) {
            List adapterRoles = adapter.getRoles(new Object[0]);
            if (adapterRoles == null || adapterRoles.isEmpty()) continue;
            roles.addAll(adapterRoles);
        }
        return roles;
    }
}

