/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.DiscretizeBin;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLIntervalFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLDiscretizeBinFactory {
    static final String KIE_PMML_DISCRETIZE_BIN_TEMPLATE_JAVA = "KiePMMLDiscretizeBinTemplate.tmpl";
    static final String KIE_PMML_DISCRETIZE_BIN_TEMPLATE = "KiePMMLDiscretizeBinTemplate";
    static final String GETKIEPMMLDISCRETIZE_BIN = "getKiePMMLDiscretizeBin";
    static final String DISCRETIZE_BIN = "discretizeBin";
    static final ClassOrInterfaceDeclaration DISCRETIZE_BIN_TEMPLATE;

    private KiePMMLDiscretizeBinFactory() {
    }

    static BlockStmt getDiscretizeBinVariableDeclaration(String variableName, DiscretizeBin discretizeBin) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)DISCRETIZE_BIN_TEMPLATE.getMethodsByName(GETKIEPMMLDISCRETIZE_BIN).get(0)).clone();
        BlockStmt discretizeBinBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(discretizeBinBody, DISCRETIZE_BIN).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", DISCRETIZE_BIN, discretizeBinBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        String nestedVariableName = String.format("%s_Interval", variableName);
        BlockStmt toAdd = KiePMMLIntervalFactory.getIntervalVariableDeclaration(nestedVariableName, discretizeBin.getInterval());
        toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        ObjectCreationExpr objectCreationExpr = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", DISCRETIZE_BIN, discretizeBinBody)))).asObjectCreationExpr();
        StringLiteralExpr nameExpr = new StringLiteralExpr(variableName);
        Expression binValueExpr = CommonCodegenUtils.getExpressionForObject(discretizeBin.getBinValue());
        NameExpr intervalExpr = new NameExpr(nestedVariableName);
        objectCreationExpr.getArguments().set(0, (Node)nameExpr);
        objectCreationExpr.getArguments().set(2, (Node)binValueExpr);
        objectCreationExpr.getArguments().set(3, (Node)intervalExpr);
        discretizeBinBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_DISCRETIZE_BIN_TEMPLATE_JAVA);
        DISCRETIZE_BIN_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_DISCRETIZE_BIN_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLDiscretizeBinTemplate"));
        ((MethodDeclaration)DISCRETIZE_BIN_TEMPLATE.getMethodsByName(GETKIEPMMLDISCRETIZE_BIN).get(0)).clone();
    }
}

