/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene.fields;

import java.util.Collection;
import java.util.Date;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LegacyDoubleField;
import org.apache.lucene.document.LegacyFloatField;
import org.apache.lucene.document.LegacyIntField;
import org.apache.lucene.document.LegacyLongField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.uberfire.ext.metadata.backend.lucene.fields.FieldFactory;
import org.uberfire.ext.metadata.backend.lucene.util.Serializer;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.attribute.FileTime;

public class SimpleFieldFactory
implements FieldFactory {
    @Override
    public IndexableField[] build(KProperty<?> property) {
        if (Enum.class.isAssignableFrom(property.getValue().getClass())) {
            if (property.isSearchable()) {
                return new IndexableField[]{new TextField(property.getName(), property.getValue().toString().toLowerCase(), Field.Store.YES)};
            }
            return new IndexableField[]{new StringField(property.getName(), property.getValue().toString().toLowerCase(), Field.Store.YES)};
        }
        if (property.getValue().getClass() == String.class) {
            if (property.isSortable()) {
                return new IndexableField[]{new SortedDocValuesField(property.getName(), new BytesRef((CharSequence)property.getValue().toString()))};
            }
            if (property.isSearchable()) {
                return new IndexableField[]{new TextField(property.getName(), property.getValue().toString(), Field.Store.YES)};
            }
            return new IndexableField[]{new StringField(property.getName(), property.getValue().toString(), Field.Store.YES)};
        }
        if (property.getValue().getClass() == Boolean.class) {
            if (property.isSearchable()) {
                return new IndexableField[]{new TextField(property.getName(), (Boolean)property.getValue() != false ? "0" : "1", Field.Store.YES)};
            }
            return new IndexableField[]{new StringField(property.getName(), (Boolean)property.getValue() != false ? "0" : "1", Field.Store.YES)};
        }
        if (property.getValue().getClass() == Integer.class) {
            if (property.isSearchable()) {
                return new IndexableField[]{new LegacyIntField(property.getName(), ((Integer)property.getValue()).intValue(), Field.Store.YES)};
            }
            return new IndexableField[]{new StoredField(property.getName(), ((Integer)property.getValue()).intValue())};
        }
        if (property.getValue().getClass() == Long.class) {
            if (property.isSearchable()) {
                return new IndexableField[]{new LegacyLongField(property.getName(), ((Long)property.getValue()).longValue(), Field.Store.YES)};
            }
            return new IndexableField[]{new StoredField(property.getName(), ((Long)property.getValue()).longValue())};
        }
        if (property.getValue().getClass() == Double.class) {
            if (property.isSearchable()) {
                return new IndexableField[]{new LegacyDoubleField(property.getName(), ((Double)property.getValue()).doubleValue(), Field.Store.YES)};
            }
            return new IndexableField[]{new StoredField(property.getName(), ((Double)property.getValue()).doubleValue())};
        }
        if (property.getValue().getClass() == Float.class) {
            if (property.isSearchable()) {
                return new IndexableField[]{new LegacyFloatField(property.getName(), ((Float)property.getValue()).floatValue(), Field.Store.YES)};
            }
            return new IndexableField[]{new StoredField(property.getName(), ((Float)property.getValue()).floatValue())};
        }
        if (FileTime.class.isAssignableFrom(property.getValue().getClass())) {
            if (property.isSearchable()) {
                return new IndexableField[]{new LegacyLongField(property.getName(), ((FileTime)property.getValue()).toMillis(), Field.Store.YES)};
            }
            return new IndexableField[]{new StoredField(property.getName(), ((FileTime)property.getValue()).toMillis())};
        }
        if (Date.class.isAssignableFrom(property.getValue().getClass())) {
            if (property.isSearchable()) {
                return new IndexableField[]{new LegacyLongField(property.getName(), ((Date)property.getValue()).getTime(), Field.Store.YES)};
            }
            return new IndexableField[]{new StoredField(property.getName(), ((Date)property.getValue()).getTime())};
        }
        if (VersionHistory.class.isAssignableFrom(property.getValue().getClass())) {
            VersionHistory versionHistory = (VersionHistory)property.getValue();
            return this.build(versionHistory);
        }
        if (Collection.class.isAssignableFrom(property.getValue().getClass())) {
            StringBuilder sb = new StringBuilder();
            for (Object ovalue : (Collection)property.getValue()) {
                sb.append(ovalue).append(' ');
            }
            if (property.isSearchable()) {
                return new IndexableField[]{new TextField(property.getName(), sb.toString(), Field.Store.YES)};
            }
            return new IndexableField[]{new StringField(property.getName(), sb.toString(), Field.Store.YES)};
        }
        try {
            return new IndexableField[]{new StoredField(property.getName(), Serializer.toByteArray(property.getValue()))};
        }
        catch (Exception ex) {
            return new IndexableField[]{new StoredField(property.getName(), property.getValue().toString())};
        }
    }

    private IndexableField[] build(final VersionHistory versionHistory) {
        if (versionHistory.records().size() == 0) {
            return new IndexableField[0];
        }
        final int lastIndex = versionHistory.records().size() - 1;
        IndexableField checkinComment = this.build(new KProperty<String>(){

            public String getName() {
                return "checkinComment";
            }

            public String getValue() {
                return ((VersionRecord)versionHistory.records().get(lastIndex)).comment();
            }

            public boolean isSearchable() {
                return true;
            }
        })[0];
        IndexableField lastModifiedBy = this.build(new KProperty<String>(){

            public String getName() {
                return "lastModifiedBy";
            }

            public String getValue() {
                return ((VersionRecord)versionHistory.records().get(lastIndex)).author();
            }

            public boolean isSearchable() {
                return true;
            }
        })[0];
        IndexableField createdBy = this.build(new KProperty<String>(){

            public String getName() {
                return "createdBy";
            }

            public String getValue() {
                return ((VersionRecord)versionHistory.records().get(0)).author();
            }

            public boolean isSearchable() {
                return true;
            }
        })[0];
        IndexableField createdDate = this.build(new KProperty<Date>(){

            public String getName() {
                return "createdDate";
            }

            public Date getValue() {
                return ((VersionRecord)versionHistory.records().get(0)).date();
            }

            public boolean isSearchable() {
                return true;
            }
        })[0];
        IndexableField lastModifiedDate = this.build(new KProperty<Date>(){

            public String getName() {
                return "lastModifiedDate";
            }

            public Date getValue() {
                return ((VersionRecord)versionHistory.records().get(lastIndex)).date();
            }

            public boolean isSearchable() {
                return true;
            }
        })[0];
        return new IndexableField[]{checkinComment, lastModifiedBy, createdBy, createdDate, lastModifiedDate};
    }
}

