/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.metrics.group;

import java.util.Collections;
import java.util.List;
import org.dashbuilder.dataprovider.kafka.mbean.ObjectNamePrototype;
import org.dashbuilder.dataprovider.kafka.metrics.KafkaMetricCollector;
import org.dashbuilder.dataprovider.kafka.metrics.MBeanMetricCollector;
import org.dashbuilder.dataprovider.kafka.metrics.group.MetricsCollectorGroup;
import org.dashbuilder.dataprovider.kafka.model.KafkaMetricsRequest;

class ProducerMetricsGroup
implements MetricsCollectorGroup {
    private static final ObjectNamePrototype KAFKA_PRODUCER_TOPIC = ObjectNamePrototype.withDomainAndType("kafka.producer", "producer-topic-metrics");
    private static final ObjectNamePrototype KAFKA_PRODUCER_NODE = ObjectNamePrototype.withDomainAndType("kafka.producer", "producer-node-metrics,client-id");
    private static final ObjectNamePrototype KAFKA_PRODUCER = ObjectNamePrototype.withDomainAndType("kafka.producer", "producer-metrics");

    ProducerMetricsGroup() {
    }

    @Override
    public List<KafkaMetricCollector> getMetricsCollectors(KafkaMetricsRequest request) {
        String clientId = request.clientId().orElseThrow(() -> new IllegalArgumentException("Client Id is required to retrieve producer metrics."));
        if (request.topic().isPresent()) {
            String mbeanName = KAFKA_PRODUCER_TOPIC.copy().hyfenClientId(clientId).topic(request.topic().get()).build();
            return Collections.singletonList(MBeanMetricCollector.metricCollector(mbeanName));
        }
        if (request.nodeId().isPresent()) {
            String mbeanName = KAFKA_PRODUCER_NODE.copy().hyfenClientId(clientId).hyfenNodeId(request.nodeId().get()).build();
            return Collections.singletonList(MBeanMetricCollector.metricCollector(mbeanName));
        }
        String mbeanName = KAFKA_PRODUCER.copy().hyfenClientId(clientId).build();
        return Collections.singletonList(MBeanMetricCollector.metricCollector(mbeanName));
    }
}

