/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.model;

import java.util.Optional;
import org.dashbuilder.dataset.def.KafkaDataSetDef;

public class KafkaMetricsRequest {
    KafkaDataSetDef.MetricsTarget metricsTarget;
    private String host;
    private String rmiPort;
    String filter;
    String clientId;
    String nodeId;
    String topic;
    String partition;

    public KafkaMetricsRequest(String host, String rmiPort) {
        this.host = host;
        this.rmiPort = rmiPort;
        this.metricsTarget = KafkaDataSetDef.MetricsTarget.BROKER;
    }

    public KafkaDataSetDef.MetricsTarget getMetricsTarget() {
        return this.metricsTarget;
    }

    public String getHost() {
        return this.host;
    }

    public String getRmiPort() {
        return this.rmiPort;
    }

    public Optional<String> clientId() {
        return Optional.ofNullable(this.clientId);
    }

    public Optional<String> nodeId() {
        return Optional.ofNullable(this.nodeId);
    }

    public Optional<String> topic() {
        return Optional.ofNullable(this.topic);
    }

    public Optional<String> partition() {
        return Optional.ofNullable(this.partition);
    }

    public Optional<String> filter() {
        return Optional.ofNullable(this.filter);
    }

    public String toString() {
        return "KafkaMetricsRequest [metricsTarget=" + this.metricsTarget + ", host=" + this.host + ", rmiPort=" + this.rmiPort + ", filter=" + this.filter + ", clientId=" + this.clientId + ", nodeId=" + this.nodeId + ", topic=" + this.topic + ", partition=" + this.partition + "]";
    }

    public static class Builder {
        KafkaMetricsRequest request;

        public static Builder newBuilder(String host, String rmiPort) {
            Builder builder = new Builder();
            builder.request = new KafkaMetricsRequest(host, rmiPort);
            return builder;
        }

        public static Builder newConsumerBuilder(String host, String rmiPort, String clientId) {
            return Builder.newBuilder(host, rmiPort).target(KafkaDataSetDef.MetricsTarget.CONSUMER).clientId(clientId);
        }

        public static Builder newProducerBuilder(String host, String rmiPort, String clientId) {
            return Builder.newBuilder(host, rmiPort).target(KafkaDataSetDef.MetricsTarget.PRODUCER).clientId(clientId);
        }

        public Builder target(KafkaDataSetDef.MetricsTarget target) {
            this.request.metricsTarget = target;
            return this;
        }

        public Builder filter(String filter) {
            this.request.filter = filter;
            return this;
        }

        public Builder clientId(String clientId) {
            this.request.clientId = clientId;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.request.nodeId = nodeId;
            return this;
        }

        public Builder topic(String topic) {
            this.request.topic = topic;
            return this;
        }

        public Builder partition(String partition) {
            this.request.partition = partition;
            return this;
        }

        public KafkaMetricsRequest build() {
            return this.request;
        }
    }
}

