/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.buffer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ReadUtil {
    private ReadUtil() {
    }

    public static void readFully(InputStream stream, byte[] bytes, int off, int len) throws IOException {
        int count;
        int remaining = len;
        do {
            if ((count = stream.read(bytes, off, remaining)) <= 0) {
                throw new EOFException("unexpected end of stream, read " + (len - remaining) + " bytes from " + len);
            }
            off += count;
        } while ((remaining -= count) > 0);
    }

    public static void readFully(InputStream stream, byte[] bytes) throws IOException {
        ReadUtil.readFully(stream, bytes, 0, bytes.length);
    }

    public static boolean eofIsNext(ByteBuffer byteBuffer) {
        return byteBuffer.get(0) == -2 && byteBuffer.limit() < 9;
    }

    public static boolean isErrorPacket(ByteBuffer byteBuffer) {
        return byteBuffer.get(0) == -1;
    }
}

