/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetRuleAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.bootstrap.BootstrapAdapterFactory;
import org.kie.workbench.common.stunner.core.registry.RegistryFactory;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;

@ApplicationScoped
public class AdapterManagerImpl
implements AdapterManager {
    private final AdapterRegistry registry;
    private final DefinitionSetAdapter<Object> definitionSetAdapter;
    private final DefinitionSetRuleAdapter<Object> definitionSetRuleAdapter;
    private final DefinitionAdapter<Object> definitionAdapter;
    private final PropertyAdapter<Object, Object> propertyAdapter;

    protected AdapterManagerImpl() {
        this.registry = null;
        this.definitionSetAdapter = null;
        this.definitionSetRuleAdapter = null;
        this.definitionAdapter = null;
        this.propertyAdapter = null;
    }

    @Inject
    public AdapterManagerImpl(RegistryFactory registryFactory, BootstrapAdapterFactory bootstrapAdapterFactory) {
        this(registryFactory.newAdapterRegistry(), bootstrapAdapterFactory);
    }

    AdapterManagerImpl(AdapterRegistry registry, BootstrapAdapterFactory bootstrapAdapterFactory) {
        this.registry = registry;
        this.definitionSetAdapter = bootstrapAdapterFactory.newDefinitionSetAdapter(registry);
        this.definitionSetRuleAdapter = bootstrapAdapterFactory.newDefinitionSetRuleAdapter(registry);
        this.definitionAdapter = bootstrapAdapterFactory.newDefinitionAdapter(registry);
        this.propertyAdapter = bootstrapAdapterFactory.newPropertyAdapter(registry);
    }

    public DefinitionSetAdapter<Object> forDefinitionSet() {
        return this.definitionSetAdapter;
    }

    public DefinitionSetRuleAdapter<Object> forRules() {
        return this.definitionSetRuleAdapter;
    }

    public DefinitionAdapter<Object> forDefinition() {
        return this.definitionAdapter;
    }

    public PropertyAdapter<Object, Object> forProperty() {
        return this.propertyAdapter;
    }

    public AdapterRegistry registry() {
        return this.registry;
    }
}

