/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.clone;

import java.util.Map;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.stunner.core.definition.clone.CloneManager;
import org.kie.workbench.common.stunner.core.definition.clone.ClonePolicy;
import org.kie.workbench.common.stunner.core.definition.clone.CloneProcess;
import org.kie.workbench.common.stunner.core.definition.clone.DefaultCloneProcess;
import org.kie.workbench.common.stunner.core.definition.clone.IDeepCloneProcess;
import org.kie.workbench.common.stunner.core.definition.clone.NoneCloneProcess;

@ApplicationScoped
public class CloneManagerImpl
implements CloneManager {
    private final Map<ClonePolicy, CloneProcess> cloneProcessMap;

    public CloneManagerImpl() {
        this(null, null, null);
    }

    @Inject
    public CloneManagerImpl(IDeepCloneProcess deepCloneProcess, DefaultCloneProcess defaultCloneProcess, NoneCloneProcess noneCloneProcess) {
        this.cloneProcessMap = new Maps.Builder().put((Object)ClonePolicy.ALL, (Object)deepCloneProcess).put((Object)ClonePolicy.DEFAULT, (Object)defaultCloneProcess).put((Object)ClonePolicy.NONE, (Object)noneCloneProcess).build();
    }

    private CloneProcess cloneProcess(ClonePolicy clonePolicy) {
        Objects.requireNonNull(clonePolicy, "ClonePolicy is required");
        return this.cloneProcessMap.get(clonePolicy);
    }

    public <T> T clone(T source, ClonePolicy policy) {
        return this.cloneProcess(policy).clone(source);
    }

    public <S, T> T clone(S source, T target, ClonePolicy policy) {
        return this.cloneProcess(policy).clone(source, target);
    }
}

