/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddChildNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddControlPointCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddDockedNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.ClearGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteElementsCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RemoveChildrenCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetChildrenCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetConnectionSourceNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPropertyValueCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@ApplicationScoped
public class GraphCommandFactory {
    public AddNodeCommand addNode(Node candidate) {
        return new AddNodeCommand(candidate);
    }

    public AddChildNodeCommand addChildNode(Node parent, Node candidate) {
        return this.addChildNode(parent, candidate, null);
    }

    public AddChildNodeCommand addChildNode(Node parent, Node candidate, Point2D location) {
        return new AddChildNodeCommand(parent, candidate, location);
    }

    public AddDockedNodeCommand addDockedNode(Node parent, Node candidate) {
        return new AddDockedNodeCommand(parent, candidate);
    }

    public AddConnectorCommand addConnector(Node target, Edge edge, Connection connection) {
        return new AddConnectorCommand(target, edge, connection);
    }

    public SetChildrenCommand setChild(Node parent, Node candidate) {
        return new SetChildrenCommand(parent, candidate);
    }

    public SetChildrenCommand setChildren(Node parent, Collection candidates) {
        return new SetChildrenCommand(parent, candidates);
    }

    public DockNodeCommand dockNode(Node parent, Node candidate) {
        return new DockNodeCommand(parent, candidate);
    }

    public MorphNodeCommand morphNode(Node<Definition, Edge> candidate, MorphDefinition morphDefinition, String morphTarget) {
        return new MorphNodeCommand(candidate, morphDefinition, morphTarget);
    }

    public SetConnectionSourceNodeCommand setSourceNode(Node<? extends View<?>, Edge> sourceNode, Edge<? extends View<?>, Node> edge, Connection connection) {
        return new SetConnectionSourceNodeCommand(sourceNode, edge, connection);
    }

    public SetConnectionTargetNodeCommand setTargetNode(Node<? extends View<?>, Edge> targetNode, Edge<? extends View<?>, Node> edge, Connection connection) {
        return new SetConnectionTargetNodeCommand(targetNode, edge, connection);
    }

    public UpdateElementPositionCommand updatePosition(Node<? extends View<?>, Edge> element, Point2D location) {
        return new UpdateElementPositionCommand(element, location);
    }

    public UpdateElementPropertyValueCommand updatePropertyValue(Element element, String field, Object value) {
        return new UpdateElementPropertyValueCommand(element, field, value);
    }

    public SafeDeleteNodeCommand safeDeleteNode(Node candidate) {
        return new SafeDeleteNodeCommand(candidate);
    }

    public DeleteNodeCommand deleteNode(Node candidate) {
        return new DeleteNodeCommand(candidate);
    }

    public DeleteElementsCommand delete(Collection<Element> elements) {
        return new DeleteElementsCommand(() -> elements);
    }

    public RemoveChildrenCommand removeChild(Node parent, Node candidate) {
        return new RemoveChildrenCommand(parent, candidate);
    }

    public RemoveChildrenCommand removeChildren(Node parent, Collection candidates) {
        return new RemoveChildrenCommand(parent, candidates);
    }

    public UnDockNodeCommand unDockNode(Node parent, Node candidate) {
        return new UnDockNodeCommand(parent, candidate);
    }

    public DeleteConnectorCommand deleteConnector(Edge<? extends View, Node> edge) {
        return new DeleteConnectorCommand(edge);
    }

    public ClearGraphCommand clearGraph() {
        return new ClearGraphCommand("");
    }

    public ClearGraphCommand clearGraph(String rootUUID) {
        return new ClearGraphCommand(rootUUID);
    }

    public AddControlPointCommand addControlPoint(Edge edge, ControlPoint controlPoint, int index) {
        return new AddControlPointCommand(edge.getUUID(), controlPoint, index);
    }
}

