/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public class UnDockNodeCommand
extends AbstractGraphCommand {
    private final String parentUUID;
    private final String candidateUUID;
    private transient Node<?, Edge> parent;
    private transient Node<?, Edge> candidate;

    public UnDockNodeCommand(@MapsTo(value="parentUUID") String parentUUID, @MapsTo(value="candidateUUID") String candidateUUID) {
        this.parentUUID = (String)PortablePreconditions.checkNotNull((String)"parentUUID", (Object)parentUUID);
        this.candidateUUID = (String)PortablePreconditions.checkNotNull((String)"candidateUUID", (Object)candidateUUID);
    }

    public UnDockNodeCommand(Node<?, Edge> parent, Node<?, Edge> candidate) {
        this(parent.getUUID(), candidate.getUUID());
        this.parent = parent;
        this.candidate = candidate;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            Node<?, Edge> parent = this.getParent(context);
            Node<?, Edge> candidate = this.getCandidate(context);
            parent.getOutEdges().stream().filter(e -> e.getContent() instanceof Dock).filter(e -> e.getTargetNode().equals(candidate)).findFirst().ifPresent(e -> this.removeDockEdge(context, parent, candidate, (Edge)e));
        }
        return results;
    }

    private void removeDockEdge(GraphCommandExecutionContext context, Node<?, Edge> parent, Node<?, Edge> candidate, Edge edge) {
        edge.setSourceNode(null);
        edge.setTargetNode(null);
        parent.getOutEdges().remove(edge);
        candidate.getInEdges().remove(edge);
        this.getMutableIndex(context).removeEdge(edge);
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        this.getParent(context);
        this.getCandidate(context);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        DockNodeCommand undoCommand = new DockNodeCommand(this.getParent(context), this.getCandidate(context));
        return undoCommand.execute(context);
    }

    private Node<?, Edge> getParent(GraphCommandExecutionContext context) {
        if (null == this.parent) {
            this.parent = this.getNodeNotNull(context, this.parentUUID);
        }
        return this.parent;
    }

    private Node<?, Edge> getCandidate(GraphCommandExecutionContext context) {
        if (null == this.candidate) {
            this.candidate = this.getNodeNotNull(context, this.candidateUUID);
        }
        return this.candidate;
    }

    public Node<?, Edge> getParent() {
        return this.parent;
    }

    public Node<?, Edge> getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return "DeleteDockEdgeCommand [parent=" + this.parentUUID + ", candidate=" + this.candidateUUID + "]";
    }
}

