/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.traverse.tree;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.uberfire.mvp.Command;

@Dependent
public final class TreeWalkTraverseProcessorImpl
implements TreeWalkTraverseProcessor {
    private Graph graph;
    private TreeTraverseCallback<Graph, Node, Edge> callback;
    private final Set<String> processesEdges = new HashSet<String>();
    private final Set<String> processesNodes = new HashSet<String>();
    private final Set<Edge> pendingEdges = new HashSet<Edge>();
    private Predicate<Node<?, Edge>> startNodePredicate = n -> n.getInEdges().isEmpty();

    public TreeWalkTraverseProcessorImpl useStartNodePredicate(Predicate<Node<?, Edge>> predicate) {
        this.startNodePredicate = predicate;
        return this;
    }

    public void traverse(Graph graph, Node node, TreeTraverseCallback<Graph, Node, Edge> callback) {
        this.startTraverse(graph, Optional.ofNullable(node), callback);
    }

    public void traverse(Graph graph, TreeTraverseCallback<Graph, Node, Edge> callback) {
        this.startTraverse(graph, Optional.empty(), callback);
    }

    private void startTraverse(Graph graph, Optional<Node<?, Edge>> node, TreeTraverseCallback<Graph, Node, Edge> callback) {
        assert (graph != null && callback != null);
        this.graph = graph;
        this.callback = callback;
        this.processesNodes.clear();
        this.processesEdges.clear();
        this.pendingEdges.clear();
        this.startGraphTraversal(node);
        this.processPendingEdges();
        this.endGraphTraversal();
        this.processesEdges.clear();
        this.pendingEdges.clear();
        this.processesNodes.clear();
        this.graph = null;
        this.callback = null;
    }

    private void startGraphTraversal(Optional<Node<?, Edge>> startNode) {
        this.callback.startGraphTraversal(this.graph);
        if (!startNode.isPresent()) {
            List<Node<?, Edge>> orderedGraphNodes = this.getStartingNodes();
            for (Node<?, Edge> node : orderedGraphNodes) {
                this.ifNotProcessed(node, () -> this.startNodeTraversal(node));
            }
        } else {
            this.startNodeTraversal(startNode.get());
        }
    }

    private void endGraphTraversal() {
        this.callback.endGraphTraversal();
    }

    private void processPendingEdges() {
        this.pendingEdges.forEach(this::processPendingEdge);
    }

    private void processPendingEdge(Edge edge) {
        this.startEdgeTraversal(edge);
    }

    private boolean isEdgeProcessed(Edge edge) {
        return this.processesEdges.contains(edge.getUUID());
    }

    private void startNodeTraversal(Node<?, Edge> node) {
        this.processesNodes.add(node.getUUID());
        if (this.callback.startNodeTraversal(node)) {
            node.getOutEdges().forEach(this::startEdgeTraversal);
            this.callback.endNodeTraversal(node);
            this.pendingEdges.addAll(node.getInEdges());
        }
    }

    private void startEdgeTraversal(Edge edge) {
        String uuid = edge.getUUID();
        if (!this.processesEdges.contains(uuid)) {
            this.processesEdges.add(uuid);
            if (this.callback.startEdgeTraversal(edge)) {
                this.ifNotProcessed(edge.getTargetNode(), () -> this.startNodeTraversal(edge.getTargetNode()));
            }
            this.endEdgeTraversal(edge);
        }
    }

    private void endEdgeTraversal(Edge edge) {
        this.callback.endEdgeTraversal(edge);
    }

    private void ifNotProcessed(Node node, Command action) {
        if (null != node && !this.processesNodes.contains(node.getUUID())) {
            action.execute();
        }
    }

    private List<Node<?, Edge>> getStartingNodes() {
        Iterable nodes = this.graph.nodes();
        LinkedList result = new LinkedList();
        nodes.forEach(n -> {
            if (this.isStartingNode((Node)n)) {
                result.add((Node<?, Edge>)n);
            }
        });
        return result;
    }

    private boolean isStartingNode(Node node) {
        return null == node.getInEdges() || this.startNodePredicate.test(node);
    }
}

