/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.registry.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.kie.workbench.common.stunner.core.registry.DynamicRegistry;
import org.kie.workbench.common.stunner.core.registry.impl.KeyProvider;

class MapRegistry<T>
implements DynamicRegistry<T> {
    private final KeyProvider<T> keyProvider;
    private final Map<String, T> items;

    MapRegistry(KeyProvider<T> keyProvider, Map<String, T> items) {
        this.keyProvider = keyProvider;
        this.items = items;
    }

    public void register(T item) {
        this.items.put(this.getItemId(item), item);
    }

    public boolean remove(T item) {
        return null != this.items.remove(this.getItemId(item));
    }

    public boolean contains(T item) {
        return this.items.containsValue(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Collection<T> getItems() {
        return Collections.unmodifiableList(new ArrayList<T>(this.items.values()));
    }

    public void clear() {
        this.items.clear();
    }

    public T getItemByKey(String key) {
        return this.items.get(key);
    }

    private String getItemId(T item) {
        return this.keyProvider.getKey(item);
    }
}

