/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly;

import java.io.Closeable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyBaseClient;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDeploymentClient;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyDriverDef;

public class WildflyDriverManagementClient
extends WildflyBaseClient {
    private WildflyDeploymentClient deploymentService = new WildflyDeploymentClient();

    @Override
    public void loadConfig(Properties properties) {
        this.deploymentService.loadConfig(properties);
        super.loadConfig(properties);
    }

    public void deploy(String deploymentId, URI uri) throws Exception {
        Path path = Paths.get(uri);
        byte[] libContent = Files.readAllBytes(path);
        this.deploymentService.deployContent(deploymentId, deploymentId, libContent, true);
    }

    public void undeploy(String deploymentId) throws Exception {
        this.deploymentService.removeDeployment(deploymentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WildflyDriverDef> getDeployedDrivers() throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("installed-drivers-list");
        if (!this.isStandalone() && this.getReferenceServerHost() != null && this.getReferenceServerName() != null) {
            operation.get("address").add("host", this.getReferenceServerHost());
            operation.get("address").add("server", this.getReferenceServerName());
        }
        operation.get("address").add("subsystem", "datasources");
        ModelControllerClient client = null;
        ArrayList<WildflyDriverDef> drivers = new ArrayList<WildflyDriverDef>();
        try {
            client = this.createControllerClient();
            ModelNode response = client.execute(operation);
            if (!this.isFailure(response)) {
                if (response.hasDefined("result")) {
                    List nodes = response.get("result").asList();
                    for (ModelNode node : nodes) {
                        WildflyDriverDef driver = new WildflyDriverDef();
                        String driverName = node.get("driver-name").asString();
                        driver.setDriverName(driverName);
                        if (node.hasDefined("deployment-name")) {
                            driver.setDeploymentName(node.get("deployment-name").asString());
                        }
                        if (node.hasDefined("driver-module-name")) {
                            driver.setDriverModuleName(node.get("driver-module-name").asString());
                        }
                        if (node.hasDefined("module-slot")) {
                            driver.setModuleSlot(node.get("module-slot").asString());
                        }
                        if (node.hasDefined("driver-class-name")) {
                            driver.setDriverClass(node.get("driver-class-name").asString());
                        }
                        if (node.hasDefined("driver-datasource-class-name")) {
                            driver.setDataSourceClass(node.get("driver-datasource-class-name").asString());
                        }
                        if (node.hasDefined("driver-xa-datasource-class-name")) {
                            driver.setXaDataSourceClass(node.get("driver-xa-datasource-class-name").asString());
                        }
                        if (node.has("driver-major-version")) {
                            driver.setMayorVersion(node.get("driver-major-version").asInt());
                        }
                        if (node.has("driver-minor-version")) {
                            driver.setMayorVersion(node.get("driver-minor-version").asInt());
                        }
                        if (node.has("jdbc-compliant")) {
                            driver.setJdbcCompliant(node.get("jdbc-compliant").asBoolean());
                        }
                        drivers.add(driver);
                    }
                }
            } else {
                this.checkResponse(response);
            }
        }
        finally {
            this.safeClose((Closeable)client);
        }
        return drivers;
    }
}

