/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.client.table;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLLabelElement;
import elemental2.dom.HTMLTableCellElement;
import elemental2.dom.HTMLTableSectionElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.presenters.AbstractArchetypeTablePresenter;

@Templated
public class ArchetypeTableView
implements AbstractArchetypeTablePresenter.View,
IsElement {
    private static final String DISABLED_CLASS = "disabled";
    private static final String PLACE_HOLDER = "placeholder";
    private AbstractArchetypeTablePresenter presenter;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="add-archetype-button")
    private HTMLButtonElement addArchetypeButton;
    @Inject
    @DataField(value="empty-add-archetype-button")
    private HTMLButtonElement emptyAddArchetypeButton;
    @Inject
    @DataField(value="search-input")
    private HTMLInputElement searchInput;
    @Inject
    @DataField(value="table-container")
    private HTMLDivElement container;
    @Inject
    @DataField(value="no-results-container")
    private HTMLDivElement noResultsContainer;
    @Inject
    @DataField(value="table-toolbar-container")
    private HTMLDivElement toolbarContainer;
    @Inject
    @DataField(value="empty-container")
    private HTMLDivElement emptyContainer;
    @Inject
    @DataField(value="pagination-container")
    private HTMLDivElement paginationContainer;
    @Inject
    @Named(value="tbody")
    @DataField(value="archetype-table-body")
    private HTMLTableSectionElement tableBody;
    @Inject
    @Named(value="th")
    @DataField(value="archetype-header-include")
    private HTMLTableCellElement headerInclude;
    @Inject
    @Named(value="th")
    @DataField(value="archetype-column-status")
    private HTMLTableCellElement headerStatus;
    @Inject
    @DataField(value="page-indicator")
    private HTMLLabelElement pageIndicator;
    @Inject
    @DataField(value="total-pages")
    @Named(value="span")
    private HTMLElement totalPages;
    @Inject
    @DataField(value="current-page")
    private HTMLInputElement currentPage;
    @Inject
    @DataField(value="previous-page")
    private HTMLLIElement previousPage;
    @Inject
    @DataField(value="next-page")
    private HTMLLIElement nextPage;
    @Inject
    @DataField(value="first-page")
    private HTMLLIElement firstPage;
    @Inject
    @DataField(value="last-page")
    private HTMLLIElement lastPage;
    @Inject
    @Named(value="span")
    @DataField(value="include-tooltip")
    private HTMLElement includeTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="group-id-tooltip")
    private HTMLElement groupIdTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="artifact-id-tooltip")
    private HTMLElement artifactIdTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="version-tooltip")
    private HTMLElement versionTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="created-date-tooltip")
    private HTMLElement createdDateTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="status-tooltip")
    private HTMLElement statusTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="actions-tooltip")
    private HTMLElement actionsTooltip;
    @Inject
    @Named(value="span")
    @DataField(value="selection-counter")
    private HTMLElement selectionCounter;

    public void init(AbstractArchetypeTablePresenter presenter) {
        this.presenter = presenter;
        this.configureHeaderTooltips();
        this.searchInput.setAttribute(PLACE_HOLDER, this.ts.getTranslation("ArchetypeManagement.Search"));
    }

    @Override
    public void showAddAction(boolean isVisible) {
        this.addArchetypeButton.hidden = !isVisible;
        this.emptyAddArchetypeButton.hidden = !isVisible;
    }

    @Override
    public void showIncludeHeader(boolean isVisible) {
        this.headerInclude.hidden = !isVisible;
    }

    @Override
    public void showStatusHeader(boolean isVisible) {
        this.headerStatus.hidden = !isVisible;
    }

    @Override
    public Element getTableBody() {
        return this.tableBody;
    }

    @Override
    public void enablePreviousButton(boolean isEnabled) {
        this.enableElement((Element)this.previousPage, isEnabled);
    }

    @Override
    public void enableNextButton(boolean isEnabled) {
        this.enableElement((Element)this.nextPage, isEnabled);
    }

    @Override
    public void enableFirstButton(boolean isEnabled) {
        this.enableElement((Element)this.firstPage, isEnabled);
    }

    @Override
    public void enableLastButton(boolean isEnabled) {
        this.enableElement((Element)this.lastPage, isEnabled);
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage.value = String.valueOf(currentPage);
    }

    @Override
    public void setTotalPages(String totalText) {
        this.totalPages.textContent = totalText;
    }

    @Override
    public void setPageIndicator(String indicatorText) {
        this.pageIndicator.textContent = indicatorText;
    }

    @Override
    public void setSelectionCounter(String counterText) {
        this.selectionCounter.textContent = counterText;
    }

    @Override
    public void showSelectionCounter(boolean isVisible) {
        this.selectionCounter.hidden = !isVisible;
    }

    @Override
    public void showNoResults(boolean isVisible) {
        this.noResultsContainer.hidden = !isVisible;
    }

    @Override
    public void showToolbar(boolean isVisible) {
        this.toolbarContainer.hidden = !isVisible;
    }

    @Override
    public void show(boolean isVisible) {
        this.container.hidden = !isVisible;
    }

    @Override
    public void showEmpty(boolean isVisible) {
        this.emptyContainer.hidden = !isVisible;
    }

    @Override
    public void showPagination(boolean isVisible) {
        this.paginationContainer.hidden = !isVisible;
    }

    @EventHandler(value={"current-page"})
    public void currentPageTextChange(KeyUpEvent event) {
        String pageNumber = this.currentPage.value;
        if (pageNumber.matches("\\d+")) {
            this.presenter.setCurrentPage(Integer.parseInt(pageNumber));
        }
    }

    @EventHandler(value={"previous-page"})
    public void onPreviousPageClicked(ClickEvent event) {
        this.presenter.goToPreviousPage();
    }

    @EventHandler(value={"next-page"})
    public void onNextPageClicked(ClickEvent event) {
        this.presenter.goToNextPage();
    }

    @EventHandler(value={"first-page"})
    public void onFirstPageClicked(ClickEvent event) {
        this.presenter.goToFirstPage();
    }

    @EventHandler(value={"last-page"})
    public void onLastPageClicked(ClickEvent event) {
        this.presenter.goToLastPage();
    }

    @EventHandler(value={"add-archetype-button"})
    public void onAddArchetypeButtonClicked(ClickEvent event) {
        this.presenter.addArchetype();
    }

    @EventHandler(value={"empty-add-archetype-button"})
    public void onEmptyAddArchetypeButtonClicked(ClickEvent event) {
        this.presenter.addArchetype();
    }

    @EventHandler(value={"search-input"})
    public void search(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.presenter.search(this.searchInput.value);
        }
    }

    private void enableElement(Element element, boolean isEnabled) {
        if (isEnabled) {
            element.classList.remove(new String[]{DISABLED_CLASS});
        } else {
            element.classList.add(new String[]{DISABLED_CLASS});
        }
    }

    private void configureHeaderTooltips() {
        this.includeTooltip.title = this.ts.getTranslation("ArchetypeManagement.IncludeTooltip");
        this.groupIdTooltip.title = this.ts.getTranslation("ArchetypeManagement.GroupIdTooltip");
        this.artifactIdTooltip.title = this.ts.getTranslation("ArchetypeManagement.ArtifactIdTooltip");
        this.versionTooltip.title = this.ts.getTranslation("ArchetypeManagement.VersionTooltip");
        this.createdDateTooltip.title = this.ts.getTranslation("ArchetypeManagement.CreatedDateTooltip");
        this.statusTooltip.title = this.ts.getTranslation("ArchetypeManagement.StatusTooltip");
        this.actionsTooltip.title = this.ts.getTranslation("ArchetypeManagement.ActionsTooltip");
    }
}

