/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Typed;

@Typed
public abstract class ProxyUtils {
    private ProxyUtils() {
    }

    public static Class getUnproxiedClass(Class currentClass) {
        Class unproxiedClass = currentClass;
        while (ProxyUtils.isProxiedClass(unproxiedClass)) {
            unproxiedClass = unproxiedClass.getSuperclass();
        }
        return unproxiedClass;
    }

    public static boolean isProxiedClass(Class currentClass) {
        if (currentClass == null || currentClass.getSuperclass() == null) {
            return false;
        }
        return currentClass.getName().startsWith(currentClass.getSuperclass().getName()) && currentClass.getName().contains("$$");
    }

    public static List<Class<?>> getProxyAndBaseTypes(Class<?> proxyClass) {
        ArrayList result = new ArrayList();
        result.add(proxyClass);
        if (ProxyUtils.isInterfaceProxy(proxyClass)) {
            for (Class<?> currentInterface : proxyClass.getInterfaces()) {
                if (!proxyClass.getName().startsWith(currentInterface.getName())) continue;
                result.add(currentInterface);
            }
        } else {
            Class<?> unproxiedClass = proxyClass.getSuperclass();
            result.add(unproxiedClass);
            while (ProxyUtils.isProxiedClass(unproxiedClass)) {
                unproxiedClass = unproxiedClass.getSuperclass();
                result.add(unproxiedClass);
            }
        }
        return result;
    }

    public static boolean isInterfaceProxy(Class<?> proxyClass) {
        Class<?>[] interfaces = proxyClass.getInterfaces();
        if (Proxy.class.equals(proxyClass.getSuperclass()) && interfaces != null && interfaces.length > 0) {
            return true;
        }
        if (proxyClass.getSuperclass() != null && !proxyClass.getSuperclass().equals(Object.class)) {
            return false;
        }
        if (proxyClass.getName().contains("$$")) {
            for (Class<?> currentInterface : interfaces) {
                if (!proxyClass.getName().startsWith(currentInterface.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

