/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.DHG;
import org.apache.sshd.common.kex.DHGroupData;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.kex.AbstractDHServerKeyExchange;
import org.apache.sshd.server.kex.Moduli;
import org.apache.sshd.server.session.ServerSession;

public class DHGEXServer
extends AbstractDHServerKeyExchange {
    protected final DHFactory factory;
    protected DHG dh;
    protected int min;
    protected int prf;
    protected int max;
    protected byte expected;
    protected boolean oldRequest;

    protected DHGEXServer(DHFactory factory) {
        this.factory = Objects.requireNonNull(factory, "No factory");
    }

    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(final DHFactory factory) {
        return new KeyExchangeFactory(){

            public KeyExchange create() {
                return new DHGEXServer(factory);
            }

            public String getName() {
                return factory.getName();
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(Session s, byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(s, v_s, v_c, i_s, i_c);
        this.expected = (byte)34;
    }

    @Override
    public boolean next(int cmd, Buffer buffer) throws Exception {
        ServerSession session = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("next({})[{}] process command={}", new Object[]{this, session, KeyExchange.getGroupKexOpcodeName(cmd)});
        }
        if (cmd == 30 && this.expected == 34) {
            this.oldRequest = true;
            this.min = 1024;
            this.prf = buffer.getInt();
            this.max = SecurityUtils.getMaxDHGroupExchangeKeySize();
            if (this.max < this.min || this.prf < this.min || this.max < this.prf) {
                throw new SshException(3, "Protocol error: bad parameters " + this.min + " !< " + this.prf + " !< " + this.max);
            }
            this.dh = this.chooseDH(this.min, this.prf, this.max);
            this.f = this.dh.getE();
            this.hash = this.dh.getHash();
            this.hash.init();
            if (debugEnabled) {
                this.log.debug("next({})[{}] send SSH_MSG_KEX_DH_GEX_GROUP", (Object)this, (Object)session);
            }
            buffer = session.createBuffer((byte)31);
            buffer.putMPInt(this.dh.getP());
            buffer.putMPInt(this.dh.getG());
            session.writePacket(buffer);
            this.expected = (byte)32;
            return false;
        }
        if (cmd == 34 && this.expected == 34) {
            this.min = buffer.getInt();
            this.prf = buffer.getInt();
            this.max = buffer.getInt();
            if (this.prf < this.min || this.max < this.prf) {
                throw new SshException(3, "Protocol error: bad parameters " + this.min + " !< " + this.prf + " !< " + this.max);
            }
            this.dh = this.chooseDH(this.min, this.prf, this.max);
            this.f = this.dh.getE();
            this.hash = this.dh.getHash();
            this.hash.init();
            if (debugEnabled) {
                this.log.debug("next({})[{}] Send SSH_MSG_KEX_DH_GEX_GROUP", (Object)this, (Object)session);
            }
            buffer = session.createBuffer((byte)31);
            buffer.putMPInt(this.dh.getP());
            buffer.putMPInt(this.dh.getG());
            session.writePacket(buffer);
            this.expected = (byte)32;
            return false;
        }
        if (cmd != this.expected) {
            throw new SshException(3, "Protocol error: expected packet " + KeyExchange.getGroupKexOpcodeName(this.expected) + ", got " + KeyExchange.getGroupKexOpcodeName(cmd));
        }
        if (cmd == 32) {
            this.e = buffer.getMPIntAsBytes();
            this.dh.setF(this.e);
            this.k = this.dh.getK();
            KeyPair kp = Objects.requireNonNull(session.getHostKey(), "No server key pair available");
            String algo = session.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
            Signature sig = (Signature)ValidateUtils.checkNotNull((Object)NamedFactory.create((Collection)session.getSignatureFactories(), (String)algo), (String)"Unknown negotiated server keys: %s", (Object)algo);
            sig.initSigner(kp.getPrivate());
            buffer = new ByteArrayBuffer();
            buffer.putRawPublicKey(kp.getPublic());
            byte[] k_s = buffer.getCompactData();
            buffer.clear();
            buffer.putBytes(this.v_c);
            buffer.putBytes(this.v_s);
            buffer.putBytes(this.i_c);
            buffer.putBytes(this.i_s);
            buffer.putBytes(k_s);
            if (this.oldRequest) {
                buffer.putInt((long)this.prf);
            } else {
                buffer.putInt((long)this.min);
                buffer.putInt((long)this.prf);
                buffer.putInt((long)this.max);
            }
            buffer.putMPInt(this.dh.getP());
            buffer.putMPInt(this.dh.getG());
            buffer.putMPInt(this.e);
            buffer.putMPInt(this.f);
            buffer.putMPInt(this.k);
            this.hash.update(buffer.array(), 0, buffer.available());
            this.h = this.hash.digest();
            sig.update(this.h);
            buffer.clear();
            buffer.putString(algo);
            byte[] sigBytes = sig.sign();
            buffer.putBytes(sigBytes);
            byte[] sigH = buffer.getCompactData();
            if (this.log.isTraceEnabled()) {
                this.log.trace("next({})[{}][K_S]:  {}", new Object[]{this, session, BufferUtils.toHex((byte[])k_s)});
                this.log.trace("next({})[{}][f]:    {}", new Object[]{this, session, BufferUtils.toHex((byte[])this.f)});
                this.log.trace("next({})[{}][sigH]: {}", new Object[]{this, session, BufferUtils.toHex((byte[])sigH)});
            }
            if (debugEnabled) {
                this.log.debug("next({})[{}] Send SSH_MSG_KEX_DH_GEX_REPLY", (Object)this, (Object)session);
            }
            buffer = session.prepareBuffer((byte)33, BufferUtils.clear((Buffer)buffer));
            buffer.putBytes(k_s);
            buffer.putBytes(this.f);
            buffer.putBytes(sigH);
            session.writePacket(buffer);
            return true;
        }
        return false;
    }

    protected DHG chooseDH(int min, int prf, int max) throws Exception {
        List<Moduli.DhGroup> groups = this.loadModuliGroups();
        min = Math.max(min, 1024);
        prf = Math.max(prf, 1024);
        prf = Math.min(prf, SecurityUtils.getMaxDHGroupExchangeKeySize());
        max = Math.min(max, SecurityUtils.getMaxDHGroupExchangeKeySize());
        int bestSize = 0;
        ArrayList<Moduli.DhGroup> selected = new ArrayList<Moduli.DhGroup>();
        boolean traceEnabled = this.log.isTraceEnabled();
        for (Moduli.DhGroup group : groups) {
            int size = group.getSize();
            if (size < min || size > max) {
                if (!traceEnabled) continue;
                this.log.trace("chooseDH - skip group={} - size not in range [{}-{}]", new Object[]{group, min, max});
                continue;
            }
            if (size > prf && size < bestSize || size > bestSize && bestSize < prf) {
                bestSize = size;
                if (traceEnabled) {
                    this.log.trace("chooseDH(prf={}, min={}, max={}) new best size={} from group={}", new Object[]{prf, min, max, bestSize, group});
                }
                selected.clear();
            }
            if (size != bestSize) continue;
            if (traceEnabled) {
                this.log.trace("chooseDH(prf={}, min={}, max={}) selected {}", new Object[]{prf, min, max, group});
            }
            selected.add(group);
        }
        ServerSession session = this.getServerSession();
        if (selected.isEmpty()) {
            this.log.warn("chooseDH({})[{}] No suitable primes found, defaulting to DHG1", (Object)this, (Object)session);
            return this.getDH(new BigInteger(DHGroupData.getP1()), new BigInteger(DHGroupData.getG()));
        }
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        Factory<Random> factory = Objects.requireNonNull(manager.getRandomFactory(), "No random factory");
        Random random = (Random)Objects.requireNonNull(factory.create(), "No random generator");
        int which = random.random(selected.size());
        Moduli.DhGroup group = (Moduli.DhGroup)selected.get(which);
        return this.getDH(group.getP(), group.getG());
    }

    protected List<Moduli.DhGroup> loadModuliGroups() throws IOException {
        URL moduli;
        ServerSession session = this.getServerSession();
        String moduliStr = session.getString("moduli-url");
        List<Moduli.DhGroup> groups = null;
        if (!GenericUtils.isEmpty((CharSequence)moduliStr)) {
            try {
                moduli = new URL(moduliStr);
                groups = Moduli.parseModuli(moduli);
            }
            catch (IOException e) {
                this.log.warn("Error (" + e.getClass().getSimpleName() + ") loading external moduli from " + moduliStr + ": " + e.getMessage());
            }
        }
        if (groups == null) {
            moduliStr = "/org/apache/sshd/moduli";
            try {
                moduli = this.getClass().getResource(moduliStr);
                if (moduli == null) {
                    throw new FileNotFoundException("Missing internal moduli file");
                }
                moduliStr = moduli.toExternalForm();
                groups = Moduli.parseModuli(moduli);
            }
            catch (IOException e) {
                this.log.warn("Error (" + e.getClass().getSimpleName() + ") loading internal moduli from " + moduliStr + ": " + e.getMessage());
                throw e;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loaded moduli groups from {}", (Object)moduliStr);
        }
        return groups;
    }

    protected DHG getDH(BigInteger p, BigInteger g) throws Exception {
        return (DHG)this.factory.create(p, g);
    }
}

