/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.compiler;

import java.util.Map;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.Scorecard;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.AbstractSpecificCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;

public class ScorecardCompilationDTO
extends AbstractSpecificCompilationDTO<Scorecard> {
    private static final long serialVersionUID = -1797184111198269074L;
    private final Scorecard scorecardModel;
    private final Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm;
    private final String characteristicsClassName;
    private final String packageCharacteristicsClassName;

    private ScorecardCompilationDTO(CompilationDTO<Scorecard> source) {
        super(source);
        this.scorecardModel = (Scorecard)source.getModel();
        this.reasonCodeAlgorithm = this.scorecardModel.getReasonCodeAlgorithm();
        this.characteristicsClassName = KiePMMLModelUtils.getGeneratedClassName((String)"Characteristics");
        this.packageCharacteristicsClassName = String.format("%s.%s", this.getPackageName(), this.characteristicsClassName);
    }

    public static ScorecardCompilationDTO fromCompilationDTO(CompilationDTO<Scorecard> source) {
        return new ScorecardCompilationDTO(source);
    }

    public Class<?> compileAndLoadCharacteristicsClass(Map<String, String> sourcesMap) {
        return this.getHasClassloader().compileAndLoadClass(sourcesMap, this.packageCharacteristicsClassName);
    }

    public Scorecard getScorecardModel() {
        return this.scorecardModel;
    }

    public Number getInitialScore() {
        return this.scorecardModel.getInitialScore();
    }

    public boolean isUseReasonCodes() {
        return this.scorecardModel.isUseReasonCodes();
    }

    public Scorecard.ReasonCodeAlgorithm getReasonCodeAlgorithm() {
        return this.reasonCodeAlgorithm;
    }

    public REASONCODE_ALGORITHM getREASONCODE_ALGORITHM() {
        return REASONCODE_ALGORITHM.byName((String)this.reasonCodeAlgorithm.value());
    }

    public Number getBaselineScore() {
        return this.scorecardModel.getBaselineScore();
    }

    public Characteristics getCharacteristics() {
        return this.scorecardModel.getCharacteristics();
    }

    public String getCharacteristicsClassName() {
        return this.characteristicsClassName;
    }

    public String getPackageCanonicalCharacteristicsClassName() {
        return this.packageCharacteristicsClassName;
    }
}

