/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.BaseCreateCommitTree;
import org.uberfire.java.nio.fs.jgit.util.commands.PathUtil;
import org.uberfire.java.nio.fs.jgit.util.model.DefaultCommitContent;

public class CreateDefaultCommitTree
extends BaseCreateCommitTree<DefaultCommitContent> {
    public CreateDefaultCommitTree(Git git, ObjectId headId, ObjectInserter inserter, DefaultCommitContent commitContent) {
        super(git, headId, inserter, commitContent);
    }

    public Optional<ObjectId> execute() {
        Map<String, File> content = ((DefaultCommitContent)this.commitContent).getContent();
        HashMap<String, Object> paths = new HashMap<String, Object>(content.size());
        HashSet<String> path2delete = new HashSet<String>();
        DirCacheEditor editor = DirCache.newInCore().editor();
        try {
            for (Map.Entry<String, File> pathAndContent : content.entrySet()) {
                String gPath = PathUtil.normalize(pathAndContent.getKey());
                if (pathAndContent.getValue() == null) {
                    path2delete.addAll(CreateDefaultCommitTree.searchPathsToDelete(this.git, this.headId, gPath));
                    continue;
                }
                paths.putAll(CreateDefaultCommitTree.storePathsIntoHashMap(this.odi, pathAndContent, gPath));
            }
            this.iterateOverTreeWalk(this.git, this.headId, (walkPath, hTree) -> {
                if (paths.containsKey(walkPath) && ((ObjectId)((Pair)paths.get(walkPath)).getK2()).equals((AnyObjectId)hTree.getEntryObjectId())) {
                    paths.remove(walkPath);
                }
                if (paths.get(walkPath) == null && !path2delete.contains(walkPath)) {
                    this.addToTemporaryInCoreIndex(editor, new DirCacheEntry(walkPath), hTree.getEntryObjectId(), hTree.getEntryFileMode());
                }
            });
            paths.forEach((key, value) -> {
                if (value.getK1() != null) {
                    editor.add(new DirCacheEditor.PathEdit(new DirCacheEntry(key), (Pair)value){
                        final /* synthetic */ Pair val$value;
                        {
                            this.val$value = pair;
                            super(ent);
                        }

                        public void apply(DirCacheEntry ent) {
                            ent.setLength(((File)this.val$value.getK1()).length());
                            ent.setLastModified(((File)this.val$value.getK1()).lastModified());
                            ent.setFileMode(FileMode.REGULAR_FILE);
                            ent.setObjectId((AnyObjectId)this.val$value.getK2());
                        }
                    });
                }
            });
            editor.finish();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (path2delete.isEmpty() && paths.isEmpty()) {
            editor.getDirCache().clear();
            return Optional.empty();
        }
        return this.buildTree(editor);
    }

    private static Map<String, Pair<File, ObjectId>> storePathsIntoHashMap(ObjectInserter inserter, Map.Entry<String, File> pathAndContent, String gPath) {
        HashMap<String, Pair<File, ObjectId>> hashMap;
        FileInputStream inputStream = new FileInputStream(pathAndContent.getValue());
        try {
            HashMap<String, Pair<File, ObjectId>> paths = new HashMap<String, Pair<File, ObjectId>>();
            ObjectId objectId = inserter.insert(3, pathAndContent.getValue().length(), (InputStream)inputStream);
            paths.put(gPath, Pair.newPair((Object)pathAndContent.getValue(), (Object)objectId));
            hashMap = paths;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        ((InputStream)inputStream).close();
        return hashMap;
    }

    private static Set<String> searchPathsToDelete(Git git, ObjectId headId, String gPath) throws IOException {
        try (TreeWalk treeWalk = new TreeWalk(git.getRepository());){
            HashSet<String> path2delete = new HashSet<String>();
            treeWalk.addTree((AnyObjectId)new RevWalk(git.getRepository()).parseTree((AnyObjectId)headId));
            treeWalk.setRecursive(true);
            treeWalk.setFilter((TreeFilter)PathFilter.create((String)gPath));
            while (treeWalk.next()) {
                path2delete.add(treeWalk.getPathString());
            }
            HashSet<String> hashSet = path2delete;
            return hashSet;
        }
    }
}

