/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.BranchUtil;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class MapDiffContent {
    private final Git git;
    private final String branch;
    private final String startCommitId;
    private final String endCommitId;

    public MapDiffContent(Git git, String branch, String startCommitId, String endCommitId) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.branch = PortablePreconditions.checkNotEmpty((String)"branch", (String)branch);
        this.startCommitId = PortablePreconditions.checkNotEmpty((String)"startCommitId", (String)startCommitId);
        this.endCommitId = PortablePreconditions.checkNotEmpty((String)"endCommitId", (String)endCommitId);
    }

    public Map<String, File> execute() {
        BranchUtil.existsBranch(this.git, this.branch);
        RevCommit startCommit = this.git.getCommit(this.startCommitId);
        RevCommit endCommit = this.git.getCommit(this.endCommitId);
        if (startCommit == null || endCommit == null) {
            throw new GitException("Given commit ids cannot be found.");
        }
        HashMap<String, File> content = new HashMap<String, File>();
        List<DiffEntry> diffs = this.git.listDiffs((ObjectId)startCommit.getTree(), (ObjectId)endCommit.getTree());
        diffs.forEach(entry -> {
            block9: {
                if (entry.getChangeType() != DiffEntry.ChangeType.DELETE) {
                    try (InputStream inputStream = this.git.blobAsInputStream(this.branch, entry.getNewPath());){
                        File file = File.createTempFile("gitz", "woot");
                        Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        content.put(entry.getNewPath(), file);
                        break block9;
                    }
                    catch (IOException e) {
                        throw new GitException("Unable to get content from diffs", e);
                    }
                }
                content.put(entry.getOldPath(), null);
            }
        });
        return content;
    }
}

