/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.VariableDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;

public abstract class InitializedVariable {
    private final String identifier;
    private final String type;
    private ItemDefinition itemDefinition;
    private static final Pattern EXPRESSION = Pattern.compile("^#\\{(.+)}$");

    public InitializedVariable(String parentId, VariableDeclaration varDecl) {
        this.identifier = varDecl.getIdentifier();
        this.type = varDecl.getType();
        this.itemDefinition = Factories.bpmn2.createItemDefinition();
        this.itemDefinition.setId(Ids.item(parentId));
        this.itemDefinition.setStructureRef(this.getType());
    }

    public static InitializedInputVariable inputOf(String parentId, VariableScope variableScope, VariableDeclaration varDecl, AssociationDeclaration associationDeclaration, Set<DataObject> dataObject) {
        if (associationDeclaration == null) {
            return new InputEmpty(parentId, varDecl);
        }
        AssociationDeclaration.Type type = associationDeclaration.getType();
        switch (type) {
            case FromTo: {
                if (associationDeclaration.getTarget() == null) {
                    return new InputEmpty(parentId, varDecl);
                }
                return InitializedVariable.createCustomInput(parentId, varDecl, associationDeclaration.getSource());
            }
            case SourceTarget: {
                return new InputVariableReference(parentId, variableScope, varDecl, associationDeclaration.getSource(), dataObject);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public static InitializedInputVariable createCustomInput(String parentId, VariableDeclaration varDecl, String expression) {
        String decodedExpression = InitializedVariable.decode(expression);
        if (EXPRESSION.matcher(decodedExpression).matches()) {
            return new InputExpression(parentId, varDecl, decodedExpression);
        }
        return new InputConstant(parentId, varDecl, decodedExpression);
    }

    private static String decode(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(text, e);
        }
    }

    public static InitializedOutputVariable outputOf(String parentId, VariableScope variableScope, VariableDeclaration varDecl, AssociationDeclaration associationDeclaration, Set<DataObject> dataObject) {
        if (associationDeclaration == null) {
            return new OutputEmpty(parentId, varDecl);
        }
        AssociationDeclaration.Type type = associationDeclaration.getType();
        switch (type) {
            case FromTo: {
                if (associationDeclaration.getTarget() == null) {
                    return new OutputEmpty(parentId, varDecl);
                }
                return new OutputExpression(parentId, varDecl, associationDeclaration.getTarget());
            }
            case SourceTarget: {
                return new OutputVariableReference(parentId, variableScope, varDecl, associationDeclaration.getTarget(), dataObject);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getType() {
        return this.type;
    }

    public ItemDefinition getItemDefinition() {
        return this.itemDefinition;
    }

    private static DataOutput dataOutputOf(String parentId, String identifier, String name, ItemDefinition itemDefinition) {
        DataOutput dataOutput = Factories.bpmn2.createDataOutput();
        dataOutput.setId(Ids.dataOutput(parentId, identifier));
        dataOutput.setName(name);
        dataOutput.setItemSubjectRef(itemDefinition);
        CustomAttribute.dtype.of((BaseElement)dataOutput).set(itemDefinition.getStructureRef());
        return dataOutput;
    }

    private static FormalExpression createCdataExpression(String value) {
        FormalExpression expression = Factories.bpmn2.createFormalExpression();
        expression.setBody(Scripts.asCData(value));
        return expression;
    }

    public static class OutputEmpty
    extends InitializedOutputVariable {
        public OutputEmpty(String parentId, VariableDeclaration varDecl) {
            super(parentId, varDecl);
        }

        @Override
        public DataOutputAssociation getDataOutputAssociation() {
            return null;
        }
    }

    public static class OutputExpression
    extends InitializedOutputVariable {
        final String expression;

        public OutputExpression(String parentId, VariableDeclaration varDecl, String expression) {
            super(parentId, varDecl);
            this.expression = InitializedVariable.decode(expression);
        }

        @Override
        public DataOutputAssociation getDataOutputAssociation() {
            DataOutputAssociation dataOutputAssociation = Factories.bpmn2.createDataOutputAssociation();
            Assignment assignment = Factories.bpmn2.createAssignment();
            String id = this.getDataOutput().getId();
            FormalExpression toExpr = Factories.bpmn2.createFormalExpression();
            toExpr.setBody(id);
            assignment.setFrom((Expression)toExpr);
            assignment.setTo((Expression)InitializedVariable.createCdataExpression(this.expression));
            dataOutputAssociation.getAssignment().add(assignment);
            dataOutputAssociation.getSourceRef().add(this.getDataOutput());
            return dataOutputAssociation;
        }
    }

    public static class InputExpression
    extends InitializedInputVariable {
        final String expression;

        public InputExpression(String parentId, VariableDeclaration varDecl, String expression) {
            super(parentId, varDecl);
            this.expression = expression;
        }

        @Override
        public DataInputAssociation getDataInputAssociation() {
            DataInputAssociation dataInputAssociation = Factories.bpmn2.createDataInputAssociation();
            Assignment assignment = Factories.bpmn2.createAssignment();
            String id = this.getDataInput().getId();
            assignment.setFrom((Expression)InitializedVariable.createCdataExpression(this.expression));
            FormalExpression toExpr = Factories.bpmn2.createFormalExpression();
            toExpr.setBody(id);
            assignment.setTo((Expression)toExpr);
            dataInputAssociation.getAssignment().add(assignment);
            dataInputAssociation.setTargetRef((ItemAwareElement)this.getDataInput());
            return dataInputAssociation;
        }
    }

    public static class InputConstant
    extends InitializedInputVariable {
        final String expression;

        public InputConstant(String parentId, VariableDeclaration varDecl, String expression) {
            super(parentId, varDecl);
            this.expression = expression;
        }

        @Override
        public DataInputAssociation getDataInputAssociation() {
            DataInputAssociation dataInputAssociation = Factories.bpmn2.createDataInputAssociation();
            Assignment assignment = Factories.bpmn2.createAssignment();
            String id = this.getDataInput().getId();
            FormalExpression toExpr = Factories.bpmn2.createFormalExpression();
            toExpr.setBody(id);
            assignment.setTo((Expression)toExpr);
            FormalExpression fromExpr = Factories.bpmn2.createFormalExpression();
            String decodedExpression = InitializedVariable.decode(this.expression);
            String cdataExpression = Scripts.asCData(decodedExpression);
            fromExpr.setBody(cdataExpression);
            assignment.setFrom((Expression)InitializedVariable.createCdataExpression(this.expression));
            dataInputAssociation.getAssignment().add(assignment);
            dataInputAssociation.setTargetRef((ItemAwareElement)this.getDataInput());
            return dataInputAssociation;
        }
    }

    public static class InputEmpty
    extends InitializedInputVariable {
        public InputEmpty(String parentId, VariableDeclaration varDecl) {
            super(parentId, varDecl);
        }

        @Override
        public DataInputAssociation getDataInputAssociation() {
            return null;
        }
    }

    public static class OutputVariableReference
    extends InitializedOutputVariable {
        private final DataOutput dataOutput;
        private final String targetVariable;
        private final VariableScope scope;
        private final Set<DataObject> dataObjects;

        public OutputVariableReference(String parentId, VariableScope scope, VariableDeclaration varDecl, String targetVariable, Set<DataObject> dataObjects) {
            super(parentId, varDecl);
            this.scope = scope;
            this.targetVariable = targetVariable;
            this.dataObjects = dataObjects;
            this.dataOutput = InitializedVariable.dataOutputOf(parentId, varDecl.getIdentifier(), varDecl.getTypedIdentifier().getName(), this.getItemDefinition());
        }

        @Override
        public DataOutput getDataOutput() {
            return this.dataOutput;
        }

        @Override
        public DataOutputAssociation getDataOutputAssociation() {
            Optional<Object> typedIdentifier = Optional.empty();
            Optional<VariableScope.Variable> maybeVariable = this.scope.lookup(this.targetVariable);
            if (maybeVariable.isPresent()) {
                typedIdentifier = Optional.of(maybeVariable.get().getTypedIdentifier());
            } else {
                for (DataObject dataObject : this.dataObjects) {
                    if (!dataObject.getId().equals(this.targetVariable)) continue;
                    typedIdentifier = Optional.of(dataObject);
                    break;
                }
            }
            return typedIdentifier.map(variable -> OutputVariableReference.associationOf(variable, this.dataOutput)).orElse(null);
        }

        private static DataOutputAssociation associationOf(ItemAwareElement source, DataOutput dataOutput) {
            DataOutputAssociation dataOutputAssociation = Factories.bpmn2.createDataOutputAssociation();
            dataOutputAssociation.getSourceRef().add(dataOutput);
            dataOutputAssociation.setTargetRef(source);
            return dataOutputAssociation;
        }
    }

    public static class InputVariableReference
    extends InitializedInputVariable {
        private final String sourceVariable;
        private final VariableScope scope;
        private final Set<DataObject> dataObjectSet;

        public InputVariableReference(String parentId, VariableScope variableScope, VariableDeclaration varDecl, String sourceVariable, Set<DataObject> dataObjectSet) {
            super(parentId, varDecl);
            this.scope = variableScope;
            this.sourceVariable = sourceVariable;
            this.dataObjectSet = dataObjectSet;
        }

        @Override
        public DataInputAssociation getDataInputAssociation() {
            DataInputAssociation dataInputAssociation = Factories.bpmn2.createDataInputAssociation();
            Optional<Object> typedIdentifier = Optional.empty();
            Optional<VariableScope.Variable> maybeVariable = this.scope.lookup(this.sourceVariable);
            if (maybeVariable.isPresent()) {
                typedIdentifier = Optional.of(maybeVariable.get().getTypedIdentifier());
            } else {
                for (DataObject dataObject : this.dataObjectSet) {
                    if (!dataObject.getId().equals(this.sourceVariable)) continue;
                    typedIdentifier = Optional.of(dataObject);
                    break;
                }
            }
            return typedIdentifier.map(variable -> dataInputAssociation.getSourceRef().add(variable)).map(added -> {
                dataInputAssociation.setTargetRef((ItemAwareElement)this.getDataInput());
                return added;
            }).map(added -> dataInputAssociation).orElse(null);
        }
    }

    public static abstract class InitializedOutputVariable
    extends InitializedVariable {
        private final DataOutput dataOutput;

        public InitializedOutputVariable(String parentId, VariableDeclaration varDecl) {
            super(parentId, varDecl);
            this.getItemDefinition().setId(Ids.dataOutputItem(parentId, varDecl.getIdentifier()));
            this.dataOutput = InitializedVariable.dataOutputOf(parentId, varDecl.getIdentifier(), varDecl.getTypedIdentifier().getName(), this.getItemDefinition());
        }

        public DataOutput getDataOutput() {
            return this.dataOutput;
        }

        public abstract DataOutputAssociation getDataOutputAssociation();
    }

    public static abstract class InitializedInputVariable
    extends InitializedVariable {
        private final DataInput dataInput;

        public InitializedInputVariable(String parentId, VariableDeclaration varDecl) {
            super(parentId, varDecl);
            this.getItemDefinition().setId(Ids.dataInputItem(parentId, varDecl.getIdentifier()));
            this.dataInput = InitializedInputVariable.dataInputOf(parentId, varDecl.getIdentifier(), varDecl.getTypedIdentifier().getName(), this.getItemDefinition());
        }

        public DataInput getDataInput() {
            return this.dataInput;
        }

        public abstract DataInputAssociation getDataInputAssociation();

        private static DataInput dataInputOf(String parentId, String identifier, String name, ItemDefinition itemDefinition) {
            DataInput dataInput = Factories.bpmn2.createDataInput();
            dataInput.setId(Ids.dataInput(parentId, identifier));
            dataInput.setName(name);
            dataInput.setItemSubjectRef(itemDefinition);
            CustomAttribute.dtype.of((BaseElement)dataInput).set(itemDefinition.getStructureRef());
            return dataInput;
        }
    }
}

