/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.events;

import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.StartEvent;
import org.kie.workbench.common.stunner.bpmn.backend.converters.NodeMatch;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.CatchEventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BaseStartEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartErrorEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartMessageEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartSignalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.InterruptingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.InterruptingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.InterruptingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.InterruptingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.InterruptingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.InterruptingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class StartEventConverter {
    private final PropertyWriterFactory propertyWriterFactory;

    public StartEventConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public PropertyWriter toFlowElement(Node<View<BaseStartEvent>, ?> node) {
        return NodeMatch.fromNode(BaseStartEvent.class, PropertyWriter.class).when(StartNoneEvent.class, this::noneEvent).when(StartSignalEvent.class, this::signalEvent).when(StartTimerEvent.class, this::timerEvent).when(StartErrorEvent.class, this::errorEvent).when(StartMessageEvent.class, this::messageEvent).when(StartConditionalEvent.class, this::conditionalEvent).when(StartEscalationEvent.class, this::escalationEvent).when(StartCompensationEvent.class, this::compensationEvent).apply(node).value();
    }

    private PropertyWriter noneEvent(Node<View<StartNoneEvent>, ?> n) {
        StartEvent event = Factories.bpmn2.createStartEvent();
        event.setId(n.getUUID());
        StartNoneEvent definition = (StartNoneEvent)((View)n.getContent()).getDefinition();
        CatchEventPropertyWriter p = this.propertyWriterFactory.of((CatchEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setSimulationSet(definition.getSimulationSet());
        BaseStartEventExecutionSet executionSet = definition.getExecutionSet();
        event.setIsInterrupting(executionSet.getIsInterrupting().getValue().booleanValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        return p;
    }

    private PropertyWriter compensationEvent(Node<View<StartCompensationEvent>, ?> n) {
        StartEvent event = Factories.bpmn2.createStartEvent();
        event.setId(n.getUUID());
        StartCompensationEvent definition = (StartCompensationEvent)((View)n.getContent()).getDefinition();
        CatchEventPropertyWriter p = this.propertyWriterFactory.of((CatchEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setSimulationSet(definition.getSimulationSet());
        BaseStartEventExecutionSet executionSet = definition.getExecutionSet();
        event.setIsInterrupting(executionSet.getIsInterrupting().getValue().booleanValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addCompensation();
        return p;
    }

    private PropertyWriter signalEvent(Node<View<StartSignalEvent>, ?> n) {
        StartEvent event = Factories.bpmn2.createStartEvent();
        event.setId(n.getUUID());
        StartSignalEvent definition = (StartSignalEvent)((View)n.getContent()).getDefinition();
        CatchEventPropertyWriter p = this.propertyWriterFactory.of((CatchEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        InterruptingSignalEventExecutionSet executionSet = definition.getExecutionSet();
        event.setIsInterrupting(executionSet.getIsInterrupting().getValue().booleanValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addSignal(executionSet.getSignalRef());
        return p;
    }

    private PropertyWriter timerEvent(Node<View<StartTimerEvent>, ?> n) {
        StartEvent event = Factories.bpmn2.createStartEvent();
        event.setId(n.getUUID());
        StartTimerEvent definition = (StartTimerEvent)((View)n.getContent()).getDefinition();
        CatchEventPropertyWriter p = this.propertyWriterFactory.of((CatchEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setSimulationSet(definition.getSimulationSet());
        InterruptingTimerEventExecutionSet executionSet = definition.getExecutionSet();
        event.setIsInterrupting(executionSet.getIsInterrupting().getValue().booleanValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addTimer(executionSet.getTimerSettings());
        return p;
    }

    private PropertyWriter conditionalEvent(Node<View<StartConditionalEvent>, ?> n) {
        StartEvent event = Factories.bpmn2.createStartEvent();
        event.setId(n.getUUID());
        StartConditionalEvent definition = (StartConditionalEvent)((View)n.getContent()).getDefinition();
        CatchEventPropertyWriter p = this.propertyWriterFactory.of((CatchEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setSimulationSet(definition.getSimulationSet());
        InterruptingConditionalEventExecutionSet executionSet = definition.getExecutionSet();
        event.setIsInterrupting(executionSet.getIsInterrupting().getValue().booleanValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addCondition(executionSet.getConditionExpression());
        return p;
    }

    private PropertyWriter errorEvent(Node<View<StartErrorEvent>, ?> n) {
        StartEvent event = Factories.bpmn2.createStartEvent();
        event.setId(n.getUUID());
        StartErrorEvent definition = (StartErrorEvent)((View)n.getContent()).getDefinition();
        CatchEventPropertyWriter p = this.propertyWriterFactory.of((CatchEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        InterruptingErrorEventExecutionSet executionSet = definition.getExecutionSet();
        event.setIsInterrupting(executionSet.getIsInterrupting().getValue().booleanValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addError(executionSet.getErrorRef());
        return p;
    }

    private PropertyWriter escalationEvent(Node<View<StartEscalationEvent>, ?> n) {
        StartEvent event = Factories.bpmn2.createStartEvent();
        event.setId(n.getUUID());
        StartEscalationEvent definition = (StartEscalationEvent)((View)n.getContent()).getDefinition();
        CatchEventPropertyWriter p = this.propertyWriterFactory.of((CatchEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setSimulationSet(definition.getSimulationSet());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        InterruptingEscalationEventExecutionSet executionSet = definition.getExecutionSet();
        event.setIsInterrupting(executionSet.getIsInterrupting().getValue().booleanValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addEscalation(executionSet.getEscalationRef());
        return p;
    }

    private PropertyWriter messageEvent(Node<View<StartMessageEvent>, ?> n) {
        StartEvent event = Factories.bpmn2.createStartEvent();
        event.setId(n.getUUID());
        StartMessageEvent definition = (StartMessageEvent)((View)n.getContent()).getDefinition();
        CatchEventPropertyWriter p = this.propertyWriterFactory.of((CatchEvent)event);
        BPMNGeneralSet general = definition.getGeneral();
        p.setName(general.getName().getValue());
        p.setDocumentation(general.getDocumentation().getValue());
        p.setMetaData(definition.getAdvancedData().getMetaDataAttributes());
        p.setAssignmentsInfo(definition.getDataIOSet().getAssignmentsinfo());
        InterruptingMessageEventExecutionSet executionSet = definition.getExecutionSet();
        event.setIsInterrupting(executionSet.getIsInterrupting().getValue().booleanValue());
        p.addSlaDueDate(executionSet.getSlaDueDate());
        p.setAbsoluteBounds(n);
        p.addMessage(executionSet.getMessageRef());
        return p;
    }
}

