/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup.rule;

import java.util.Set;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest;
import org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequestBuilder;

@Portable
public class RuleLookupRequest
extends AbstractLookupRequest {
    private final String definitionSetId;

    public RuleLookupRequest(@MapsTo(value="criteria") String criteria, @MapsTo(value="page") int page, @MapsTo(value="pageSize") int pageSize, @MapsTo(value="definitionSetId") String definitionSetId) {
        super(criteria, page, pageSize);
        this.definitionSetId = definitionSetId;
    }

    public String getDefinitionSetId() {
        return this.definitionSetId;
    }

    @NonPortable
    public static class Builder
    extends AbstractLookupRequestBuilder<Builder> {
        private String defSetId;
        private final StringBuilder criteria = new StringBuilder();

        public Builder id(String id) {
            this.criteria.append("id=").append(id).append(";");
            return this;
        }

        public Builder type(RuleType ruleType) {
            this.criteria.append("type=").append(ruleType.toString().toLowerCase()).append(";");
            return this;
        }

        public Builder definitionSetId(String defSetId) {
            this.defSetId = defSetId;
            return this;
        }

        public Builder from(Set<String> labels) {
            this.criteria.append("from=").append(this.fromSet(labels)).append(";");
            return this;
        }

        public Builder role(String role) {
            this.criteria.append("role=").append(role).append(";");
            return this;
        }

        public Builder roleIn(Set<String> roles) {
            this.criteria.append("roleIn=").append(this.fromSet(roles)).append(";");
            return this;
        }

        public Builder edgeType(EdgeType type) {
            this.criteria.append(" edgeType=").append(type.name().toLowerCase()).append(";");
            return this;
        }

        public RuleLookupRequest build() {
            return new RuleLookupRequest(this.criteria.toString(), this.page, this.pageSize, this.defSetId);
        }

        public static enum EdgeType {
            INCOMING,
            OUTGOING;

        }

        public static enum RuleType {
            CONNECTION,
            CONTAINMENT,
            CARDINALITY,
            EDGECARDINALITY;

        }
    }
}

