/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.forms.backend.service;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.forms.backend.service.FormDefinitionGenerator;
import org.kie.workbench.common.stunner.forms.service.FormGeneratedEvent;
import org.kie.workbench.common.stunner.forms.service.FormGenerationFailureEvent;
import org.kie.workbench.common.stunner.forms.service.FormGenerationService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
@Service
public class FormGenerationServiceImpl
implements FormGenerationService {
    private static Logger LOGGER = Logger.getLogger(FormGenerationServiceImpl.class.getName());
    private final Event<FormGeneratedEvent> formGeneratedEvent;
    private final Event<FormGenerationFailureEvent> formGenerationFailureEvent;
    private final FormDefinitionGenerator formDefinitionGenerator;

    protected FormGenerationServiceImpl() {
        this(null, null, null);
    }

    @Inject
    public FormGenerationServiceImpl(Event<FormGeneratedEvent> formGeneratedEvent, Event<FormGenerationFailureEvent> formGenerationFailureEvent, FormDefinitionGenerator formDefinitionGenerator) {
        this.formGeneratedEvent = formGeneratedEvent;
        this.formGenerationFailureEvent = formGenerationFailureEvent;
        this.formDefinitionGenerator = formDefinitionGenerator;
    }

    public void generateProcessForm(Diagram diagram) {
        this.doGenerate(diagram, () -> this.formDefinitionGenerator.generateProcessForm(diagram));
    }

    public void generateAllForms(Diagram diagram) {
        this.doGenerate(diagram, () -> this.formDefinitionGenerator.generateAllForms(diagram));
    }

    public void generateSelectedForms(Diagram diagram, String[] ids) {
        this.doGenerate(diagram, () -> this.formDefinitionGenerator.generateSelectedForms(diagram, ids));
    }

    private void doGenerate(Diagram diagram, Runnable runnable) {
        LOGGER.finest("Starting form generation...");
        Metadata metadata = diagram.getMetadata();
        String definitionSetId = metadata.getDefinitionSetId();
        String graphUUID = diagram.getGraph().getUUID();
        Path path = metadata.getPath();
        String fileName = null != path ? path.getFileName() : "<no-file>";
        LOGGER.finest("FormGeneration test [definitionSetId=" + definitionSetId + "[graphUUID=" + graphUUID + "[path=" + path + "[fileName=" + fileName);
        try {
            runnable.run();
            this.formGeneratedEvent.fire((Object)new FormGeneratedEvent(graphUUID, diagram.getName()));
            LOGGER.finest("Form generation completed successfully!");
        }
        catch (Throwable e) {
            this.formGenerationFailureEvent.fire((Object)new FormGenerationFailureEvent(graphUUID, diagram.getName()));
            LOGGER.severe("Error during Form Generation service: " + e.getMessage());
        }
    }
}

