/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.security.WorkbenchUserManager;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

@ApplicationScoped
@Alternative
public class ElytronAuthenticationService
implements AuthenticationService {
    private WorkbenchUserManager workbenchUserManager;
    private final ThreadLocal<User> userOnThisThread = new ThreadLocal();

    public ElytronAuthenticationService() {
    }

    @Inject
    public ElytronAuthenticationService(WorkbenchUserManager workbenchUserManager) {
        this.workbenchUserManager = workbenchUserManager;
    }

    public User login(String username, String password) {
        try {
            PasswordGuessEvidence evidence = new PasswordGuessEvidence(password.toCharArray());
            this.login(username, (Evidence)evidence);
            User user = this.workbenchUserManager.getUser(username);
            this.userOnThisThread.set(user);
            return user;
        }
        catch (RealmUnavailableException e) {
            throw new FailedAuthenticationException();
        }
        catch (Exception e) {
            throw new FailedAuthenticationException();
        }
    }

    protected void login(String username, Evidence evidence) throws RealmUnavailableException {
        SecurityDomain.getCurrent().authenticate(username, evidence);
    }

    public boolean isLoggedIn() {
        return this.userOnThisThread.get() != null;
    }

    public void logout() {
        this.userOnThisThread.remove();
    }

    public User getUser() {
        User user = this.userOnThisThread.get();
        if (user == null) {
            return User.ANONYMOUS;
        }
        return user;
    }
}

