/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.security.ElytronAuthenticationService;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.backend.server.security.IOSecurityAuth;
import org.uberfire.backend.server.security.JAASAuthenticationService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.java.nio.file.FileSystemMetadata;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.security.SecuredFileSystemProvider;
import org.uberfire.security.Resource;
import org.uberfire.security.WorkbenchUserManager;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;
import org.uberfire.ssh.service.backend.auth.SSHKeyAuthenticator;

@ApplicationScoped
@Startup
public class IOServiceSecuritySetup {
    public static final String AUTH_DOMAIN_KEY = "org.uberfire.domain";
    private static final Logger LOG = LoggerFactory.getLogger(IOServiceSecuritySetup.class);
    @Inject
    @IOSecurityAuth
    Instance<AuthenticationService> authenticationManagers;
    @Inject
    AuthenticationService httpAuthManager;
    @Inject
    AuthorizationManager authorizationManager;
    @Inject
    RepositoryService repositoryService;
    @Inject
    SpacesAPI spacesAPI;
    @Inject
    SSHKeyAuthenticator sshKeyAuthenticator;
    @Inject
    WorkbenchUserManager workbenchUserManager;

    @PostConstruct
    public void setup() {
        Object nonHTTPAuthenticationManager;
        if (this.authenticationManagers.isUnsatisfied()) {
            String authType = System.getProperty("org.uberfire.io.auth", null);
            String domain = System.getProperty(AUTH_DOMAIN_KEY, "ApplicationRealm");
            nonHTTPAuthenticationManager = authType == null ? new ElytronAuthenticationService(this.workbenchUserManager) : (authType.toLowerCase().equals("jaas") || authType.toLowerCase().equals("container") ? new JAASAuthenticationService(domain) : this.loadClazz(authType, AuthenticationService.class));
        } else {
            nonHTTPAuthenticationManager = (AuthenticationService)this.authenticationManagers.get();
        }
        for (FileSystemProvider fp : FileSystemProviders.installedProviders()) {
            if (!(fp instanceof SecuredFileSystemProvider)) continue;
            SecuredFileSystemProvider sfp = (SecuredFileSystemProvider)fp;
            sfp.setJAASAuthenticator(nonHTTPAuthenticationManager);
            sfp.setHTTPAuthenticator(this.httpAuthManager);
            sfp.setAuthorizer((fs, fileSystemUser) -> {
                Path vfsPath = Paths.convert(fs.getPath(fs.getName(), new String[0]));
                Space space = (Space)this.spacesAPI.resolveSpace(vfsPath.toURI()).orElseThrow(() -> new IllegalArgumentException("Cannot resolve space from given path: " + vfsPath));
                Repository repository = this.repositoryService.getRepositoryFromSpace(space, vfsPath.getFileName());
                if (repository == null) {
                    return this.authorizationManager.authorize((Resource)new FileSystemResourceAdaptor(new FileSystemMetadata(fs)), fileSystemUser);
                }
                return this.authorizationManager.authorize((Resource)repository, repository.getContributors(), RepositoryAction.READ, fileSystemUser);
            });
            sfp.setSSHAuthenticator((userName, key) -> this.sshKeyAuthenticator.authenticate(userName, key));
        }
    }

    private <T> T loadClazz(String clazzName, Class<T> typeOf) {
        if (clazzName == null || clazzName.isEmpty()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            if (!typeOf.isAssignableFrom(clazz)) {
                LOG.error("Class '" + clazzName + "' is not assignable to expected type " + typeOf + ". Continuing as if no class was specified.");
                return null;
            }
            return typeOf.cast(clazz.newInstance());
        }
        catch (Exception e) {
            LOG.error("Failed to load class '" + clazzName + "' as type " + typeOf + ". Continuing as if none was specified.", (Throwable)e);
            return null;
        }
    }
}

