/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.definition.ReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.validation.BPMNViolation;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.validation.DomainValidator;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;

public abstract class BPMNReusableSubProcessValidator
implements DomainValidator {
    public String getDefinitionSetId() {
        return BindableAdapterUtils.getDefinitionSetId(BPMNDefinitionSet.class);
    }

    public void validate(Diagram diagram, Consumer<Collection<DomainViolation>> resultConsumer) {
        Iterator it = diagram.getGraph().nodes().iterator();
        ArrayList<DomainViolation> violations = new ArrayList<DomainViolation>();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            this.checkElementForViolations(violations, element);
        }
        resultConsumer.accept(violations);
    }

    protected void checkElementForViolations(List<DomainViolation> violations, Element element) {
        if (this.isReusableAndHasNoInputs(element)) {
            this.addViolation(violations, element);
        }
    }

    protected void addViolation(List<DomainViolation> violations, Element element) {
        ReusableSubprocess subprocess = (ReusableSubprocess)((View)element.getContent()).getDefinition();
        BPMNViolation bpmnViolation = new BPMNViolation(this.getMessageSubprocessWithoutDataIOAssignments() + " : " + subprocess.getGeneral().getName().getValue(), Violation.Type.WARNING, element.getUUID());
        violations.add(bpmnViolation);
    }

    protected boolean isReusableSubProcess(Element element) {
        return element.getContent() instanceof View && ((View)element.getContent()).getDefinition() instanceof ReusableSubprocess;
    }

    protected boolean hasNoDataInputsOutputs(Element element) {
        ReusableSubprocess subprocess = (ReusableSubprocess)((View)element.getContent()).getDefinition();
        AssignmentsInfo assignmentsInfo = subprocess.getDataIOSet().getAssignmentsinfo();
        return this.hasNoAssignmentsDataInput(assignmentsInfo) || this.hasNoAssignmentsDataOutput(assignmentsInfo);
    }

    protected boolean isReusableAndHasNoInputs(Element element) {
        return this.isReusableSubProcess(element) && this.hasNoDataInputsOutputs(element);
    }

    public abstract String getMessageSubprocessWithoutDataIOAssignments();

    public abstract boolean hasNoAssignmentsDataInput(AssignmentsInfo var1);

    public abstract boolean hasNoAssignmentsDataOutput(AssignmentsInfo var1);
}

