/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.editor.backend.indexing;

import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.HasNestedForm;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.IsCRUDDefinition;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.services.refactoring.Resource;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;

public class FormDefinitionVisitor
extends ResourceReferenceCollector {
    private final Resource resParts;

    public FormDefinitionVisitor(Resource resParts) {
        this.resParts = resParts;
    }

    public void visit(FormDefinition formDefinition) {
        this.addResource(formDefinition.getId(), ResourceType.FORM);
        formDefinition.getFields().forEach(fieldDefinition -> this.visit((FieldDefinition)fieldDefinition));
    }

    public void visit(FieldDefinition fieldDefinition) {
        this.resParts.addPart(fieldDefinition.getName(), PartType.FORM_FIELD);
        this.addResourceReference(fieldDefinition.getStandaloneClassName(), ResourceType.JAVA);
        if (fieldDefinition instanceof HasNestedForm) {
            HasNestedForm nestedForm = (HasNestedForm)fieldDefinition;
            this.addResourceReference(nestedForm.getNestedForm(), ResourceType.FORM);
        } else if (fieldDefinition instanceof IsCRUDDefinition) {
            IsCRUDDefinition crudDefinition = (IsCRUDDefinition)fieldDefinition;
            this.addResourceReference(crudDefinition.getCreationForm(), ResourceType.FORM);
            this.addResourceReference(crudDefinition.getEditionForm(), ResourceType.FORM);
        }
    }
}

