/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.repository.service;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jbpm.process.workitem.repository.RepositoryEventListener;
import org.jbpm.process.workitem.repository.RepositoryStorage;
import org.jbpm.process.workitem.repository.ServiceTaskNotFoundException;
import org.jbpm.process.workitem.repository.service.RepoData;
import org.jbpm.process.workitem.repository.service.RepoModule;
import org.jbpm.process.workitem.repository.storage.InMemoryRepositoryStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoService {
    private static final Logger logger = LoggerFactory.getLogger(RepoService.class);
    public static final String CREATED = "Created";
    public static final String SKIPPED = "Skipped";
    private String serviceInfoVarDeclaration = "var serviceinfo = ";
    private List<RepoData> services;
    private List<RepoModule> modules = new ArrayList<RepoModule>();
    private RepositoryStorage<?> storage = new InMemoryRepositoryStorage();
    private Set<RepositoryEventListener> listeners = new LinkedHashSet<RepositoryEventListener>();

    public RepoService() {
        this.loadServices(null);
    }

    public RepoService(String jsonInput) {
        this.loadServices(jsonInput);
    }

    public RepoService(RepositoryStorage<?> storage, RepositoryEventListener ... eventListeners) {
        this.storage = storage;
        this.listeners.addAll(Arrays.asList(eventListeners));
        this.loadServices(null);
    }

    protected void loadServices(String jsonInput) {
        try {
            if (jsonInput == null || jsonInput.length() < 1) {
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("serviceinfo.js");
                jsonInput = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            }
            if (jsonInput.startsWith(this.serviceInfoVarDeclaration)) {
                jsonInput = jsonInput.substring(this.serviceInfoVarDeclaration.length());
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_MISSING_VALUES, true);
            mapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
            mapper.configure(JsonParser.Feature.ALLOW_MISSING_VALUES, true);
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            List currentServices = (List)mapper.readValue(jsonInput, (TypeReference)new TypeReference<List<RepoData>>(){});
            currentServices.removeAll(Collections.singleton(null));
            this.services = this.storage.synchronizeServices(currentServices);
            this.loadModules();
        }
        catch (Exception e) {
            logger.error("Unable to load service info: " + e.getMessage());
        }
    }

    protected void loadModules() {
        for (RepoData repoData : this.services) {
            boolean found = false;
            for (RepoModule repoModule : this.modules) {
                if (!repoModule.getName().equals(repoData.getModule())) continue;
                repoModule.addRepoData(repoData);
                found = true;
            }
            if (found) continue;
            RepoModule repoModule = new RepoModule();
            repoModule.setName(repoData.getModule());
            repoModule.addRepoData(repoData);
            this.modules.add(repoModule);
        }
    }

    public void addService(RepoData service, Map<String, List<String>> resultMap) {
        List repoDataList = this.services.stream().filter(repoData -> repoData.getName().equals(service.getName())).collect(Collectors.toList());
        if (repoDataList.isEmpty() && !this.services.isEmpty()) {
            this.addNewService(service, resultMap);
        } else {
            this.skipService(service, resultMap);
        }
        this.listeners.forEach(listener -> listener.onServiceTaskAdded(service));
    }

    public void addService(RepoData service) {
        this.services.add(service);
        this.storage.onAdded(service);
        this.listeners.forEach(listener -> listener.onServiceTaskAdded(service));
    }

    private void addNewService(RepoData service, Map<String, List<String>> resultMap) {
        List<String> createdList = resultMap.get(CREATED);
        if (createdList == null) {
            createdList = new ArrayList<String>();
            resultMap.put(CREATED, createdList);
        }
        createdList.add(service.getName());
        this.addService(service);
    }

    public void removeServiceTask(String serviceTaskId) {
        Optional<RepoData> removeServiceTask = this.services.stream().filter(service -> service.getId().equals(serviceTaskId)).findFirst();
        removeServiceTask.ifPresent(serviceTask -> {
            if (serviceTask.isEnabled()) {
                this.disableService(serviceTaskId);
            }
            this.services.remove(removeServiceTask.get());
        });
    }

    private void skipService(RepoData service, Map<String, List<String>> resultMap) {
        List<String> updatedList = resultMap.get(SKIPPED);
        if (updatedList == null) {
            updatedList = new ArrayList<String>();
            resultMap.put(SKIPPED, updatedList);
        }
        updatedList.add(service.getName());
    }

    public List<RepoData> getServices() {
        return this.storage.loadServices(0, 100);
    }

    public RepoData getServiceByName(String name) {
        List<RepoData> servicesByName = this.storage.loadServices(service -> service.getName().equalsIgnoreCase(name), 0, 100);
        if (servicesByName.isEmpty()) {
            return null;
        }
        return servicesByName.get(0);
    }

    public void enableService(String serviceId) {
        for (RepoData service : this.services) {
            if (!service.getId().equals(serviceId)) continue;
            service.setEnabled(true);
            this.storage.onEnabled(service);
            this.listeners.forEach(listener -> listener.onServiceTaskEnabled(service));
            return;
        }
        throw new ServiceTaskNotFoundException("Service with id " + serviceId + " was not found");
    }

    public void disableService(String serviceId) {
        for (RepoData service : this.services) {
            if (!service.getId().equals(serviceId)) continue;
            service.setEnabled(false);
            this.storage.onDisabled(service);
            this.listeners.forEach(listener -> listener.onServiceTaskDisabled(service));
            return;
        }
        throw new ServiceTaskNotFoundException("Service with id " + serviceId + " was not found");
    }

    public void installService(String serviceId, String target, List<String> parameters, String branchName) {
        for (RepoData service : this.services) {
            if (!service.getId().equals(serviceId)) continue;
            service.install(target, branchName);
            this.storage.onInstalled(service, target);
            this.listeners.forEach(listener -> listener.onServiceTaskInstalled(service, target, parameters, branchName));
            return;
        }
        throw new ServiceTaskNotFoundException("Service with id " + serviceId + " was not found");
    }

    public void uninstallService(String serviceId, String target, String branchName) {
        for (RepoData service : this.services) {
            if (!service.getId().equals(serviceId)) continue;
            service.uninstall(target, branchName);
            this.storage.onUninstalled(service, target);
            this.listeners.forEach(listener -> listener.onServiceTaskUninstalled(service, target, branchName));
            return;
        }
        throw new ServiceTaskNotFoundException("Service with id " + serviceId + " was not found");
    }

    public List<RepoData> getServicesByCategory(String category) {
        return this.storage.loadServices(service -> service.getCategory().equalsIgnoreCase(category), 0, 100);
    }

    public List<RepoData> getTriggerServices() {
        return this.storage.loadServices(service -> service.getIstrigger().equalsIgnoreCase("true"), 0, 100);
    }

    public List<RepoData> getActionServices() {
        return this.storage.loadServices(service -> service.getIsaction().equalsIgnoreCase("true"), 0, 100);
    }

    public List<RepoModule> getModules() {
        return this.modules;
    }

    public RepoModule getModuleByName(String name) {
        for (RepoModule repoModule : this.modules) {
            if (repoModule == null || repoModule.getName() == null || !repoModule.getName().equals(name)) continue;
            return repoModule;
        }
        return null;
    }

    public List<RepoModule> getEnabledModules() {
        List<RepoModule> retList = this.modules.stream().filter(rm -> rm.isEnabled()).collect(Collectors.toList());
        return retList;
    }

    public List<RepoModule> getDisabledModules() {
        List<RepoModule> retList = this.modules.stream().filter(rm -> !rm.isEnabled()).collect(Collectors.toList());
        return retList;
    }

    public void enableModule(String moduleName) {
        this.modules.stream().forEach(rm -> {
            if (rm.getName().equals(moduleName)) {
                rm.setEnabled(true);
                for (RepoData rd : rm.getRepoData()) {
                    this.enableService(rd.getId());
                }
            }
        });
    }

    public void disableModule(String moduleName) {
        this.modules.stream().forEach(rm -> {
            if (rm.getName().equals(moduleName)) {
                rm.setEnabled(false);
                for (RepoData rd : rm.getRepoData()) {
                    this.disableService(rd.getId());
                }
            }
        });
    }

    public List<RepoModule> getInstalledModules() {
        List<RepoModule> retList = this.modules.stream().filter(rm -> rm.isInstalled()).collect(Collectors.toList());
        return retList;
    }

    public List<RepoModule> getUninstalledModules() {
        List<RepoModule> retList = this.modules.stream().filter(rm -> !rm.isInstalled()).collect(Collectors.toList());
        return retList;
    }

    public void installModule(String moduleName, String target) {
        this.modules.stream().forEach(rm -> {
            if (rm.getName().equals(moduleName)) {
                rm.setInstalled(true);
                for (RepoData rd : rm.getRepoData()) {
                    this.installService(rd.getId(), target, null, null);
                }
            }
        });
    }

    public void uninstallModule(String moduleName, String target) {
        this.modules.stream().forEach(rm -> {
            if (rm.getName().equals(moduleName)) {
                rm.setInstalled(false);
                for (RepoData rd : rm.getRepoData()) {
                    this.uninstallService(rd.getId(), target, null);
                }
            }
        });
    }

    public void updateInstalled(String newBranchName, String fromBranchName) {
        for (RepoData service : this.services) {
            service.updateInstalled(newBranchName, fromBranchName);
        }
    }
}

