/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.forge.roaster.model.SyntaxError;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.services.datamodeller.driver.model.DriverError;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DataModelerServiceHelper {
    private KieModuleService moduleService;
    private IOService ioService;
    private CommentedOptionFactory commentedOptionFactory;

    public DataModelerServiceHelper() {
    }

    @Inject
    public DataModelerServiceHelper(KieModuleService moduleService, @Named(value="ioStrategy") IOService ioService, CommentedOptionFactory commentedOptionFactory) {
        this.moduleService = moduleService;
        this.ioService = ioService;
        this.commentedOptionFactory = commentedOptionFactory;
    }

    public List<DataModelerError> toDataModelerError(List<DriverError> errors) {
        ArrayList<DataModelerError> result = new ArrayList<DataModelerError>();
        if (errors == null) {
            return result;
        }
        for (DriverError error : errors) {
            DataModelerError dataModelerError = new DataModelerError(error.getId(), error.getMessage(), Level.ERROR, error.getFile(), error.getLine(), error.getColumn());
            result.add(dataModelerError);
        }
        return result;
    }

    public List<DataModelerError> toDataModelerError(List<SyntaxError> syntaxErrors, Path file) {
        ArrayList<DataModelerError> errors = new ArrayList<DataModelerError>();
        for (SyntaxError syntaxError : syntaxErrors) {
            DataModelerError error = new DataModelerError(syntaxError.getDescription(), syntaxError.isError() ? Level.ERROR : Level.WARNING, Paths.convert((Path)file));
            error.setColumn(syntaxError.getColumn());
            error.setLine(syntaxError.getLine());
            errors.add(error);
        }
        return errors;
    }

    public List<ValidationMessage> toValidationMessage(List<DataModelerError> errors) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (errors == null) {
            return validationMessages;
        }
        for (DataModelerError error : errors) {
            ValidationMessage validationMessage = new ValidationMessage();
            validationMessage.setPath(error.getFile());
            validationMessage.setText(error.getMessage());
            validationMessage.setColumn(error.getColumn());
            validationMessage.setLine(error.getLine());
            validationMessage.setId(error.getId());
            if (error.getLevel() != null) {
                validationMessage.setLevel(error.getLevel());
            }
            validationMessages.add(validationMessage);
        }
        return validationMessages;
    }

    public CommentedOption makeCommentedOption(String commitMessage) {
        return this.commentedOptionFactory.makeCommentedOption(commitMessage);
    }

    public Package ensurePackageStructure(Module module, String packageName) {
        String newPackageName;
        if (packageName == null || "".equals(packageName) || module == null) {
            return null;
        }
        Package defaultPackage = this.moduleService.resolveDefaultPackage(module);
        Path defaultPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)defaultPackage.getPackageMainSrcPath());
        Path newPackagePath = defaultPackagePath.resolve(newPackageName = packageName.replace(".", "/"));
        if (!this.ioService.exists(newPackagePath)) {
            return this.moduleService.newPackage(defaultPackage, packageName);
        }
        return this.moduleService.resolvePackage(Paths.convert((Path)newPackagePath));
    }

    public Set<String> resolvePackages(Module project) {
        Set packages = this.moduleService.resolvePackages(project);
        return packages.stream().map(Package::getPackageName).collect(Collectors.toSet());
    }

    public String calculateClassName(Module module, org.uberfire.backend.vfs.Path path) {
        PortablePreconditions.checkNotNull((String)"module", (Object)module);
        if (path == null) {
            return null;
        }
        Package defaultPackage = this.moduleService.resolveDefaultPackage(module);
        if (defaultPackage == null) {
            return null;
        }
        Path mainSrcNioPath = Paths.convert((org.uberfire.backend.vfs.Path)defaultPackage.getPackageMainSrcPath());
        Path testSrcNioPath = Paths.convert((org.uberfire.backend.vfs.Path)defaultPackage.getPackageTestSrcPath());
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Object relativePath = null;
        if (mainSrcNioPath != null && nioPath.startsWith(mainSrcNioPath)) {
            relativePath = mainSrcNioPath.relativize(nioPath);
        } else if (testSrcNioPath != null && nioPath.startsWith(testSrcNioPath)) {
            relativePath = testSrcNioPath.relativize(nioPath);
        }
        if (relativePath != null) {
            String className = relativePath.toString().replace("/", ".");
            return className.substring(0, className.lastIndexOf(".java"));
        }
        return null;
    }

    public Path calculateFilePath(String className, Path javaPath) {
        PortablePreconditions.checkNotNull((String)"className", (Object)className);
        PortablePreconditions.checkNotNull((String)"javaPath", (Object)javaPath);
        String pathUri = className;
        if (className.contains(".")) {
            pathUri = className.replace(".", "/");
        }
        return javaPath.resolve(pathUri + ".java");
    }
}

