/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractKieContainerService;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.backend.server.DMNScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.backend.server.RULEScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.kie.api.runtime.KieContainer;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class ScenarioValidationService
extends AbstractKieContainerService {
    public List<FactMappingValidationError> validateSimulationStructure(Simulation simulation, Settings settings, Path path) {
        List factMappings = simulation.getScesimModelDescriptor().getFactMappings();
        if (factMappings.stream().allMatch(AbstractScenarioValidation::isToSkip)) {
            return Collections.emptyList();
        }
        KieContainer kieContainer = this.getKieContainer(path);
        ScenarioSimulationModel.Type type = settings.getType();
        if (ScenarioSimulationModel.Type.DMN.equals((Object)type)) {
            return this.validateDMN(simulation, settings, kieContainer);
        }
        if (ScenarioSimulationModel.Type.RULE.equals((Object)type)) {
            return this.validateRULE(simulation, settings, kieContainer);
        }
        throw new IllegalArgumentException("Only DMN and RULE test scenarios can be validated");
    }

    protected List<FactMappingValidationError> validateDMN(Simulation simulation, Settings settings, KieContainer kieContainer) {
        return DMNScenarioValidation.INSTANCE.validate(simulation, settings, kieContainer);
    }

    protected List<FactMappingValidationError> validateRULE(Simulation simulation, Settings settings, KieContainer kieContainer) {
        return RULEScenarioValidation.INSTANCE.validate(simulation, settings, kieContainer);
    }
}

