/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.events.AfterPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.AfterStageExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforePipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforeStageExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorStageExecutionEvent;
import org.guvnor.ala.pipeline.events.PipelineEvent;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.pipeline.execution.PipelineExecutorError;
import org.guvnor.ala.pipeline.execution.PipelineExecutorException;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskManager;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.pipeline.execution.RegistrableOutput;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImplHelper;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTraceImpl;
import org.guvnor.ala.registry.PipelineExecutorRegistry;
import org.guvnor.ala.registry.PipelineRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PipelineExecutorTaskManagerImpl
implements PipelineExecutorTaskManager {
    private static final Logger logger = LoggerFactory.getLogger(PipelineExecutorTaskManagerImpl.class);
    protected static final int DEFAULT_THREAD_POOL_SIZE = 10;
    protected static final String THREAD_POOL_SIZE_PROPERTY_NAME = "org.guvnor.ala.pipeline.execution.threadPoolSize";
    protected ExecutorService executor;
    protected List<PipelineEventListener> externalListeners;
    protected PipelineExecutor pipelineExecutor;
    protected final Map<String, TaskEntry> currentTasks = new HashMap<String, TaskEntry>();
    protected Map<String, Future<?>> futureTaskMap = new HashMap();
    protected PipelineExecutorRegistry pipelineExecutorRegistry;
    protected PipelineRegistry pipelineRegistry;
    protected PipelineEventListener localListener;
    protected PipelineExecutorTaskManagerImplHelper taskManagerHelper;
    private static final Set<PipelineExecutorTask.Status> stopEnabledStatus = new HashSet<PipelineExecutorTask.Status>(){
        {
            this.add(PipelineExecutorTask.Status.RUNNING);
            this.add(PipelineExecutorTask.Status.SCHEDULED);
        }
    };
    private static final Set<PipelineExecutorTask.Status> deleteEnabledStatus = new HashSet<PipelineExecutorTask.Status>(){
        {
            this.add(PipelineExecutorTask.Status.STOPPED);
            this.add(PipelineExecutorTask.Status.ERROR);
            this.add(PipelineExecutorTask.Status.FINISHED);
        }
    };

    public PipelineExecutorTaskManagerImpl() {
    }

    @Inject
    public PipelineExecutorTaskManagerImpl(PipelineRegistry pipelineRegistry, Instance<ConfigExecutor> configExecutorInstance, Instance<PipelineEventListener> pipelineEventListenerInstance, PipelineExecutorRegistry pipelineExecutorRegistry) {
        this.pipelineRegistry = pipelineRegistry;
        this.taskManagerHelper = new PipelineExecutorTaskManagerImplHelper(configExecutorInstance, pipelineEventListenerInstance);
        this.pipelineExecutorRegistry = pipelineExecutorRegistry;
    }

    @PostConstruct
    protected void init() {
        this.initExecutor();
        this.initPipelineExecutor();
        this.initLocalListener();
        this.initExternalListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    protected void destroy() {
        try {
            Map<String, TaskEntry> map = this.currentTasks;
            synchronized (map) {
                HashSet<TaskEntry> entrySet = new HashSet<TaskEntry>();
                entrySet.addAll(this.currentTasks.values());
                entrySet.forEach(entry -> {
                    PipelineExecutorTaskImpl task;
                    this.currentTasks.remove(entry.getTask().getId());
                    if (entry.isAsync() && stopEnabledStatus.contains((Object)(task = entry.getTask()).getPipelineStatus())) {
                        try {
                            this.taskManagerHelper.setTaskInStoppedStatus(task);
                            this.updateExecutorRegistry(task);
                        }
                        catch (Exception e) {
                            logger.error("It was not possible to update task: " + task.getId() + " during  PipelineExecutorTaskManager finalization. " + e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        catch (Exception e) {
            logger.error("executor shutdown failed. " + e.getMessage(), (Throwable)e);
        }
    }

    private void initExecutor() {
        this.executor = this.taskManagerHelper.createExecutorService();
    }

    private void initPipelineExecutor() {
        this.pipelineExecutor = this.taskManagerHelper.createPipelineExecutor();
    }

    private void initLocalListener() {
        this.localListener = new PipelineEventListener(){

            @Override
            public void beforePipelineExecution(BeforePipelineExecutionEvent bpee) {
                TaskEntry taskEntry = PipelineExecutorTaskManagerImpl.this.getTaskEntry(bpee.getExecutionId());
                if (taskEntry != null) {
                    PipelineExecutorTaskManagerImpl.this.beforePipelineExecution(bpee, taskEntry);
                    PipelineExecutorTaskManagerImpl.this.notifyExternalListeners(bpee);
                }
            }

            @Override
            public void afterPipelineExecution(AfterPipelineExecutionEvent apee) {
                TaskEntry taskEntry = PipelineExecutorTaskManagerImpl.this.getTaskEntry(apee.getExecutionId());
                if (taskEntry != null) {
                    PipelineExecutorTaskManagerImpl.this.afterPipelineExecution(apee, taskEntry);
                    PipelineExecutorTaskManagerImpl.this.notifyExternalListeners(apee);
                }
            }

            @Override
            public void beforeStageExecution(BeforeStageExecutionEvent bsee) {
                TaskEntry taskEntry = PipelineExecutorTaskManagerImpl.this.getTaskEntry(bsee.getExecutionId());
                if (taskEntry != null) {
                    PipelineExecutorTaskManagerImpl.this.beforeStageExecution(bsee, taskEntry);
                    PipelineExecutorTaskManagerImpl.this.notifyExternalListeners(bsee);
                }
            }

            @Override
            public void onStageError(OnErrorStageExecutionEvent oesee) {
                TaskEntry taskEntry = PipelineExecutorTaskManagerImpl.this.getTaskEntry(oesee.getExecutionId());
                if (taskEntry != null) {
                    PipelineExecutorTaskManagerImpl.this.onStageError(oesee, taskEntry);
                    PipelineExecutorTaskManagerImpl.this.notifyExternalListeners(oesee);
                }
            }

            @Override
            public void afterStageExecution(AfterStageExecutionEvent asee) {
                TaskEntry taskEntry = PipelineExecutorTaskManagerImpl.this.getTaskEntry(asee.getExecutionId());
                if (taskEntry != null) {
                    PipelineExecutorTaskManagerImpl.this.afterStageExecution(asee, taskEntry);
                    PipelineExecutorTaskManagerImpl.this.notifyExternalListeners(asee);
                }
            }

            @Override
            public void onPipelineError(OnErrorPipelineExecutionEvent oepee) {
                TaskEntry taskEntry = PipelineExecutorTaskManagerImpl.this.getTaskEntry(oepee.getExecutionId());
                if (taskEntry != null) {
                    PipelineExecutorTaskManagerImpl.this.onPipelineError(oepee, taskEntry);
                    PipelineExecutorTaskManagerImpl.this.notifyExternalListeners(oepee);
                }
            }
        };
    }

    private void initExternalListeners() {
        this.externalListeners = this.taskManagerHelper.createExternalListeners();
    }

    @Override
    public String execute(PipelineExecutorTaskDef taskDef, PipelineExecutorTaskManager.ExecutionMode executionMode) {
        if (executionMode == PipelineExecutorTaskManager.ExecutionMode.ASYNCHRONOUS) {
            return this.executeAsync(taskDef);
        }
        return this.executeSync(taskDef);
    }

    private synchronized String executeAsync(PipelineExecutorTaskDef taskDef) {
        PipelineExecutorTaskImpl task = this.taskManagerHelper.createTask(taskDef);
        this.storeTaskEntry(TaskEntry.newAsyncEntry(task));
        this.startAsyncTask(task);
        this.updateExecutorRegistry(task);
        return task.getId();
    }

    private synchronized void startAsyncTask(PipelineExecutorTask task) {
        Future<?> future = this.executor.submit(() -> {
            Pipeline pipeline = this.pipelineRegistry.getPipelineByName(task.getTaskDef().getPipeline());
            try {
                this.pipelineExecutor.execute(task.getTaskDef().getInput(), pipeline, output -> this.processPipelineOutput(task, output), this.localListener);
            }
            catch (Exception e) {
                logger.error("An error was produced during pipeline execution for PipelineExecutorTask: " + task.getId(), (Throwable)e);
            }
            finally {
                this.removeTaskEntry(task.getId());
                this.removeFutureTask(task.getId());
            }
        });
        this.storeFutureTask(task.getId(), future);
    }

    private String executeSync(PipelineExecutorTaskDef taskDef) {
        PipelineExecutorTaskImpl task = this.taskManagerHelper.createTask(taskDef);
        this.storeTaskEntry(TaskEntry.newSyncEntry(task));
        Pipeline pipeline = this.pipelineRegistry.getPipelineByName(taskDef.getPipeline());
        this.pipelineExecutor.execute(taskDef.getInput(), pipeline, output -> this.processPipelineOutput(task, output), this.localListener);
        this.removeTaskEntry(task.getId());
        this.updateExecutorRegistry(task);
        return task.getId();
    }

    private void processPipelineOutput(PipelineExecutorTask task, Object output) {
        if (output instanceof RegistrableOutput) {
            ((PipelineExecutorTaskImpl)task).setOutput((RegistrableOutput)output);
        } else {
            logger.debug("Only pipeline outputs of type RegistrableOutput will be registered, current output value won't be registered: " + output);
        }
    }

    @Override
    public void stop(String taskId) throws PipelineExecutorException {
        TaskEntry entry = this.getTaskEntry(taskId);
        if (entry == null) {
            throw new PipelineExecutorException("No PipelineExecutorTask was found for taskId: " + taskId);
        }
        if (!entry.isAsync()) {
            throw new PipelineExecutorException("Stop operation is not available for taskId: " + taskId + " running in SYNCHRONOUS mode");
        }
        PipelineExecutorTask.Status currentStatus = entry.getTask().getPipelineStatus();
        if (!stopEnabledStatus.contains((Object)currentStatus)) {
            throw new PipelineExecutorException("A PipelineExecutorTask in status: " + currentStatus.name() + " can not be stopped. Stop operation is available for the following status set: " + stopEnabledStatus);
        }
        this.destroyFutureTask(taskId);
        this.removeTaskEntry(taskId);
        this.taskManagerHelper.setTaskInStoppedStatus(entry.getTask());
        this.updateExecutorRegistry(entry.getTask());
    }

    @Override
    public void destroy(String taskId) throws PipelineExecutorException {
        TaskEntry entry = this.getTaskEntry(taskId);
        if (entry == null) {
            throw new PipelineExecutorException("No PipelineExecutorTask was found for taskId: " + taskId);
        }
        if (!entry.isAsync()) {
            throw new PipelineExecutorException("Destroy operation is not available for taskId: " + taskId + " running in SYNCHRONOUS mode");
        }
        this.destroyFutureTask(taskId);
        this.removeTaskEntry(taskId);
        this.pipelineExecutorRegistry.deregister(taskId);
    }

    @Override
    public void delete(String taskId) throws PipelineExecutorException {
        TaskEntry entry = this.getTaskEntry(taskId);
        if (entry != null) {
            throw new PipelineExecutorException("An active PipelineExecutorTask was found for taskId: " + taskId + " delete operation is only available for the following status set: " + deleteEnabledStatus);
        }
        PipelineExecutorTrace trace = this.pipelineExecutorRegistry.getExecutorTrace(taskId);
        if (trace == null) {
            throw new PipelineExecutorException("No PipelineExecutorTask was found for taskId: " + taskId);
        }
        if (!deleteEnabledStatus.contains((Object)trace.getTask().getPipelineStatus())) {
            throw new PipelineExecutorException("A PipelineExecutorTask in status: " + trace.getTask().getPipelineStatus().name() + " can not be deleted. Delete operation is available for the following status set: " + deleteEnabledStatus);
        }
        this.pipelineExecutorRegistry.deregister(taskId);
    }

    private void beforePipelineExecution(BeforePipelineExecutionEvent bpee, TaskEntry taskEntry) {
        taskEntry.getTask().setPipelineStatus(PipelineExecutorTask.Status.RUNNING);
        if (taskEntry.isAsync()) {
            this.updateExecutorRegistry(taskEntry.getTask());
        }
    }

    private void afterPipelineExecution(AfterPipelineExecutionEvent apee, TaskEntry taskEntry) {
        taskEntry.getTask().setPipelineStatus(PipelineExecutorTask.Status.FINISHED);
        if (taskEntry.isAsync()) {
            this.updateExecutorRegistry(taskEntry.getTask());
        }
    }

    private void beforeStageExecution(BeforeStageExecutionEvent bsee, TaskEntry taskEntry) {
        taskEntry.getTask().setStageStatus(bsee.getStage().getName(), PipelineExecutorTask.Status.RUNNING);
        if (taskEntry.isAsync()) {
            this.updateExecutorRegistry(taskEntry.getTask());
        }
    }

    private void onStageError(OnErrorStageExecutionEvent oesee, TaskEntry taskEntry) {
        taskEntry.getTask().setPipelineStatus(PipelineExecutorTask.Status.ERROR);
        taskEntry.getTask().setStageStatus(oesee.getStage().getName(), PipelineExecutorTask.Status.ERROR);
        taskEntry.getTask().setStageError(oesee.getStage().getName(), new PipelineExecutorError(oesee.getError().getMessage(), oesee.getError()));
        if (taskEntry.isAsync()) {
            this.updateExecutorRegistry(taskEntry.getTask());
        }
    }

    private void afterStageExecution(AfterStageExecutionEvent asee, TaskEntry taskEntry) {
        taskEntry.getTask().setStageStatus(asee.getStage().getName(), PipelineExecutorTask.Status.FINISHED);
        if (taskEntry.isAsync()) {
            this.updateExecutorRegistry(taskEntry.getTask());
        }
    }

    private void onPipelineError(OnErrorPipelineExecutionEvent oepee, TaskEntry taskEntry) {
        taskEntry.getTask().setPipelineStatus(PipelineExecutorTask.Status.ERROR);
        taskEntry.getTask().setPipelineError(new PipelineExecutorError(oepee.getError().getMessage(), oepee.getError()));
        if (taskEntry.isAsync()) {
            this.updateExecutorRegistry(taskEntry.getTask());
        }
    }

    private synchronized TaskEntry getTaskEntry(String taskId) {
        return this.currentTasks.get(taskId);
    }

    private synchronized void removeTaskEntry(String taskId) {
        this.currentTasks.remove(taskId);
    }

    private synchronized void storeTaskEntry(TaskEntry entry) {
        this.currentTasks.put(entry.task.getId(), entry);
    }

    private synchronized void storeFutureTask(String taskId, Future future) {
        this.futureTaskMap.put(taskId, future);
    }

    private synchronized void removeFutureTask(String taskId) {
        this.futureTaskMap.remove(taskId);
    }

    private synchronized boolean destroyFutureTask(String taskId) {
        Future<?> future = this.futureTaskMap.remove(taskId);
        if (future != null && !future.isCancelled() && !future.isDone()) {
            try {
                future.cancel(true);
            }
            catch (Exception e) {
                logger.error("Cancellation of Future task: " + taskId + " failed. " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private void notifyExternalListeners(PipelineEvent event) {
        this.taskManagerHelper.notifyExternalListeners(this.externalListeners, event);
    }

    private void updateExecutorRegistry(PipelineExecutorTaskImpl task) {
        try {
            PipelineExecutorTaskImpl clone = (PipelineExecutorTaskImpl)task.clone();
            this.pipelineExecutorRegistry.register(new PipelineExecutorTraceImpl(clone));
        }
        catch (Exception e) {
            logger.error("Unexpected error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static class TaskEntry {
        private PipelineExecutorTaskImpl task;
        private PipelineExecutorTaskManager.ExecutionMode executionMode;

        private TaskEntry(PipelineExecutorTaskImpl task, PipelineExecutorTaskManager.ExecutionMode executionMode) {
            this.task = task;
            this.executionMode = executionMode;
        }

        public static TaskEntry newAsyncEntry(PipelineExecutorTaskImpl task) {
            return new TaskEntry(task, PipelineExecutorTaskManager.ExecutionMode.ASYNCHRONOUS);
        }

        public static TaskEntry newSyncEntry(PipelineExecutorTaskImpl task) {
            return new TaskEntry(task, PipelineExecutorTaskManager.ExecutionMode.SYNCHRONOUS);
        }

        public PipelineExecutorTaskImpl getTask() {
            return this.task;
        }

        public boolean isAsync() {
            return PipelineExecutorTaskManager.ExecutionMode.ASYNCHRONOUS == this.executionMode;
        }
    }
}

