/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.okta;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupBuilder;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.okta.OktaAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="OktaCreateGroup.wid", name="OktaCreateGroup", displayName="OktaCreateGroup", defaultHandler="mvel: new org.jbpm.process.workitem.okta.CreateGroupWorkitemHandler(\"apiToken\")", documentation="okta-workitem/index.html", category="okta-workitem", icon="OktaCreateGroup.png", parameters={@WidParameter(name="GroupName", required=true), @WidParameter(name="GroupDescription", required=true)}, results={@WidResult(name="GroupId")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="okta-workitem", version="7.64.0.Final")}, serviceInfo=@WidService(category="Okta", description="Interact with Okta management API", keywords="okta,auth,group,create", action=@WidAction(title="Create new group to Okta"), authinfo=@WidAuth(required=true, params={"apiToken"}, paramsdescription={"Okta api token"}, referencesite="https://developer.okta.com/")))
public class CreateGroupWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private Client oktaClient;
    private OktaAuth auth = new OktaAuth();
    private static final String RESULTS_VALUE = "GroupId";

    public CreateGroupWorkitemHandler() throws Exception {
        try {
            this.oktaClient = this.auth.authorize();
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public CreateGroupWorkitemHandler(String apiToken) throws Exception {
        try {
            this.oktaClient = this.auth.authorize(apiToken);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public CreateGroupWorkitemHandler(Client oktaClient) {
        this.oktaClient = oktaClient;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String groupName = (String)workItem.getParameter("GroupName");
            String groupDescription = (String)workItem.getParameter("GroupDescription");
            Group group = GroupBuilder.instance().setName(groupName).setDescription(groupDescription).buildAndCreate(this.oktaClient);
            HashMap<String, String> results = new HashMap<String, String>();
            results.put(RESULTS_VALUE, group.getId());
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

