/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak.elytron;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.Alternative;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.keycloak.adapters.jaas.DirectAccessGrantsLoginModule;
import org.keycloak.adapters.jaas.RolePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.security.elytron.ElytronIdentityHelper;

@Alternative
public class KeyCloakElytronIdentityHelper
implements ElytronIdentityHelper {
    public static final String KEYCLOAK_CONFIG_FILE_KEY = "keycloak-config-file";
    public static final String KIE_GIT_FILE_SYSTEM_PROP = "org.uberfire.ext.security.keycloak.keycloak-config-file";
    public static final String DEFAULT_KIE_GIT_FILE_PATH = System.getProperty("jboss.home.dir") + "/kie-git.json";
    private static final Logger logger = LoggerFactory.getLogger(KeyCloakElytronIdentityHelper.class);
    private final String configFile;
    private final DirectAccessGrantsLoginModule keycloakDelegate;

    public KeyCloakElytronIdentityHelper() {
        this(new DirectAccessGrantsLoginModule());
    }

    KeyCloakElytronIdentityHelper(DirectAccessGrantsLoginModule keycloakDelegate) {
        this.keycloakDelegate = keycloakDelegate;
        this.configFile = System.getProperty(KIE_GIT_FILE_SYSTEM_PROP, DEFAULT_KIE_GIT_FILE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getIdentity(final String userName, String password) {
        Subject subject = new Subject();
        subject.getPrincipals().add(new Principal(){
            private final String name;
            {
                this.name = userName;
            }

            @Override
            public String getName() {
                return this.name;
            }
        });
        subject.getPublicCredentials().add(password);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(KEYCLOAK_CONFIG_FILE_KEY, this.configFile);
        this.keycloakDelegate.initialize(subject, (CallbackHandler)new ElytronHelperCallbackHandler(userName, password), new HashMap(), options);
        try {
            if (this.keycloakDelegate.login()) {
                this.keycloakDelegate.commit();
                Collection roles = subject.getPrincipals(RolePrincipal.class).stream().map(principal -> new RoleImpl(principal.getName())).collect(Collectors.toList());
                UserImpl userImpl = new UserImpl(userName, roles);
                return userImpl;
            }
        }
        catch (Exception ex) {
            logger.debug("Identity provided for '{}' not valid", (Object)userName);
        }
        finally {
            try {
                this.keycloakDelegate.logout();
            }
            catch (LoginException e) {
                logger.debug("Error logging out user '{}'", (Object)userName);
            }
        }
        throw new FailedAuthenticationException();
    }

    static class ElytronHelperCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String password;

        public ElytronHelperCallbackHandler(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) {
            Stream.of(callbacks).forEach(callback -> {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.userName);
                } else if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(this.password.toCharArray());
                } else {
                    logger.debug("Unrecognized Callback {}", callback);
                }
            });
        }
    }
}

