/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Arrays;
import java.util.Set;
import javax.validation.Valid;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.dmn.api.definition.DMNViewDefinition;
import org.kie.workbench.common.dmn.api.definition.HasText;
import org.kie.workbench.common.dmn.api.definition.model.Artifact;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.TextFormat;
import org.kie.workbench.common.dmn.api.property.styling.StylingSet;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.kie.workbench.common.forms.adf.definitions.annotations.FieldParam;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormDefinition;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.forms.adf.definitions.annotations.i18n.I18nSettings;
import org.kie.workbench.common.forms.adf.definitions.settings.FieldPolicy;
import org.kie.workbench.common.stunner.core.definition.annotation.Definition;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Category;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Labels;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
@Bindable
@Definition
@FormDefinition(policy=FieldPolicy.ONLY_MARKED, defaultFieldSettings={@FieldParam(name="nestedFormContainer", value="COLLAPSIBLE")}, i18n=@I18nSettings(keyPreffix="org.kie.workbench.common.dmn.api.definition.model.TextAnnotation"), startElement="id")
public class TextAnnotation
extends Artifact
implements DMNViewDefinition<GeneralRectangleDimensionsSet>,
HasText,
HasContentDefinitionId,
DynamicReadOnly {
    private static final String[] READONLY_FIELDS = new String[]{"Description", "Text", "TextFormat"};
    protected boolean allowOnlyVisualChange;
    private String dmnDiagramId;
    @Category
    private static final String stunnerCategory = "DMNNodes";
    @Labels
    private static final Set<String> stunnerLabels = new Sets.Builder().add((Object)"text-annotation").build();
    @Property(meta=PropertyMetaTypes.NAME)
    @FormField(afterElement="description")
    protected Text text;
    @Property
    @FormField(afterElement="text", labelKey="text")
    protected TextFormat textFormat;
    @Property
    @FormField(afterElement="variable")
    @Valid
    protected StylingSet stylingSet;
    @Property
    protected GeneralRectangleDimensionsSet dimensionsSet;

    public TextAnnotation() {
        this(new Id(), new Description(), new Text(), new TextFormat(), new StylingSet(), new GeneralRectangleDimensionsSet());
    }

    public TextAnnotation(Id id, Description description, Text text, TextFormat textFormat, StylingSet stylingSet, GeneralRectangleDimensionsSet dimensionsSet) {
        super(id, description);
        this.text = text;
        this.textFormat = textFormat;
        this.stylingSet = stylingSet;
        this.dimensionsSet = dimensionsSet;
    }

    public String getStunnerCategory() {
        return stunnerCategory;
    }

    public Set<String> getStunnerLabels() {
        return stunnerLabels;
    }

    @Override
    public StylingSet getStylingSet() {
        return this.stylingSet;
    }

    public void setStylingSet(StylingSet stylingSet) {
        this.stylingSet = stylingSet;
    }

    @Override
    public GeneralRectangleDimensionsSet getDimensionsSet() {
        return this.dimensionsSet;
    }

    public void setDimensionsSet(GeneralRectangleDimensionsSet dimensionsSet) {
        this.dimensionsSet = dimensionsSet;
    }

    @Override
    public Text getText() {
        return this.text;
    }

    @Override
    public void setText(Text text) {
        this.text = text;
    }

    public TextFormat getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(TextFormat textFormat) {
        this.textFormat = textFormat;
    }

    public String getContentDefinitionId() {
        return this.getId().getValue();
    }

    public String getDiagramId() {
        return this.dmnDiagramId;
    }

    public void setContentDefinitionId(String contentDefinitionId) {
        this.setId(new Id(contentDefinitionId));
    }

    public void setDiagramId(String dmnDiagramId) {
        this.dmnDiagramId = dmnDiagramId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextAnnotation)) {
            return false;
        }
        TextAnnotation that = (TextAnnotation)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.textFormat != null ? !this.textFormat.equals(that.textFormat) : that.textFormat != null) {
            return false;
        }
        if (this.stylingSet != null ? !this.stylingSet.equals(that.stylingSet) : that.stylingSet != null) {
            return false;
        }
        return this.dimensionsSet != null ? this.dimensionsSet.equals(that.dimensionsSet) : that.dimensionsSet == null;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.id != null ? this.id.hashCode() : 0, this.description != null ? this.description.hashCode() : 0, this.text != null ? this.text.hashCode() : 0, this.textFormat != null ? this.textFormat.hashCode() : 0, this.stylingSet != null ? this.stylingSet.hashCode() : 0, this.dimensionsSet != null ? this.dimensionsSet.hashCode() : 0});
    }

    public void setAllowOnlyVisualChange(boolean allowOnlyVisualChange) {
        this.allowOnlyVisualChange = allowOnlyVisualChange;
    }

    public boolean isAllowOnlyVisualChange() {
        return this.allowOnlyVisualChange;
    }

    public DynamicReadOnly.ReadOnly getReadOnly(String fieldName) {
        if (!this.isAllowOnlyVisualChange()) {
            return DynamicReadOnly.ReadOnly.NOT_SET;
        }
        if (this.isReadonlyField(fieldName)) {
            return DynamicReadOnly.ReadOnly.TRUE;
        }
        return DynamicReadOnly.ReadOnly.FALSE;
    }

    protected boolean isReadonlyField(String fieldName) {
        return Arrays.stream(READONLY_FIELDS).anyMatch(f -> f.equalsIgnoreCase(fieldName));
    }
}

