/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.definition.adapter.bind;

import java.lang.reflect.Field;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.ReflectionAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BackendBindableAdapterFunctions
implements BindableAdapterFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(BackendBindableAdapterFunctions.class);

    public Object getValue(Object property, String fieldName) {
        return BackendBindableAdapterFunctions.getFieldValue(property, fieldName);
    }

    public static Object getFieldValue(Object property, String fieldName) {
        try {
            return ReflectionAdapterUtils.getValue(property, fieldName);
        }
        catch (IllegalAccessException e) {
            LOG.error("Error obtaining value for field " + fieldName);
            return null;
        }
    }

    public void setValue(Object property, String fieldName, Object value) {
        BackendBindableAdapterFunctions.setFieldValue(property, fieldName, value);
    }

    public static void setFieldValue(Object property, String fieldName, Object value) {
        Field field = ReflectionAdapterUtils.getField(property, fieldName);
        if (null != field) {
            try {
                field.setAccessible(true);
                field.set(property, value);
            }
            catch (Exception e) {
                LOG.error("Error setting value for field " + fieldName);
            }
        }
    }
}

