/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jboss.forge.roaster.model.ValuePair;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.driver.AnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.kie.workbench.common.services.datamodeller.util.PortableStringUtils;
import org.kie.workbench.common.services.datamodeller.util.StringEscapeUtils;

public class DefaultJavaRoasterModelAnnotationDriver
implements AnnotationDriver {
    @Override
    public Annotation buildAnnotation(AnnotationDefinition annotationDefinition, Object annotationToken) throws ModelDriverException {
        List values;
        AnnotationSource javaAnnotationToken = (AnnotationSource)annotationToken;
        AnnotationImpl annotation = new AnnotationImpl(annotationDefinition);
        if (annotationDefinition.isMarker()) {
            return annotation;
        }
        if (javaAnnotationToken.getValues() != null && (values = javaAnnotationToken.getValues()) != null && values.size() > 0) {
            for (AnnotationValuePairDefinition valuePairDefinition : annotationDefinition.getValuePairs()) {
                Object annotationValue = this.buildAnnotationValue(javaAnnotationToken, valuePairDefinition);
                if (annotationValue == null) continue;
                annotation.setValue(valuePairDefinition.getName(), annotationValue);
            }
        }
        return annotation;
    }

    private Object buildAnnotationValue(AnnotationSource javaAnnotationToken, AnnotationValuePairDefinition valuePairDefinition) throws ModelDriverException {
        Object result = null;
        if (javaAnnotationToken.getLiteralValue(valuePairDefinition.getName()) != null) {
            if (valuePairDefinition.isPrimitiveType()) {
                result = this.parsePrimitiveValue(javaAnnotationToken, valuePairDefinition);
            } else if (valuePairDefinition.isEnum()) {
                result = this.parseEnumValue(javaAnnotationToken, valuePairDefinition);
            } else if (valuePairDefinition.isString()) {
                result = this.parseStringValue(javaAnnotationToken, valuePairDefinition);
            } else if (valuePairDefinition.isClass()) {
                result = this.parseClassValue(javaAnnotationToken, valuePairDefinition);
            } else if (valuePairDefinition.isAnnotation()) {
                result = this.parseAnnotationValue(javaAnnotationToken, valuePairDefinition);
            }
        }
        return result;
    }

    private Object parsePrimitiveValue(AnnotationSource javaAnnotationToken, AnnotationValuePairDefinition valuePairDefinition) {
        String value = this.parseLiteralValue(javaAnnotationToken.getLiteralValue(valuePairDefinition.getName()));
        if (value == null) {
            return null;
        }
        List<Object> result = valuePairDefinition.isArray() ? this.parsePrimitiveArrayValue(value, valuePairDefinition.getClassName(), valuePairDefinition) : this.parsePrimitiveValue(value, valuePairDefinition.getClassName());
        return result;
    }

    private Object parseEnumValue(AnnotationSource javaAnnotationToken, AnnotationValuePairDefinition valuePairDefinition) {
        String value = this.parseLiteralValue(javaAnnotationToken.getLiteralValue(valuePairDefinition.getName()));
        if (value == null) {
            return null;
        }
        Object result = valuePairDefinition.isArray() ? this.parseEnumArrayValue(value, valuePairDefinition) : this.parseEnumValue(value, valuePairDefinition);
        return result;
    }

    private Object parseStringValue(AnnotationSource javaAnnotationToken, AnnotationValuePairDefinition valuePairDefinition) {
        Object result = null;
        if (valuePairDefinition.isArray()) {
            String[] arrayValue = javaAnnotationToken.getStringArrayValue(valuePairDefinition.getName());
            if (arrayValue != null) {
                result = Arrays.asList(arrayValue);
            }
        } else {
            result = javaAnnotationToken.getStringValue(valuePairDefinition.getName());
        }
        return result;
    }

    private Object parseClassValue(AnnotationSource javaAnnotationToken, AnnotationValuePairDefinition valuePairDefinition) {
        Object value = null;
        List values = javaAnnotationToken.getValues();
        if (values != null) {
            Optional<ValuePair> valuePair = values.stream().filter(vp -> valuePairDefinition.getName().equals(vp.getName())).findFirst();
            value = valuePair.map(vp -> vp.getLiteralValue()).orElse(null);
        }
        if (value == null) {
            return null;
        }
        Object result = valuePairDefinition.isArray() ? this.parseClassArrayValue((String)value) : value;
        return result;
    }

    private Object parseAnnotationValue(AnnotationSource javaAnnotationToken, AnnotationValuePairDefinition valuePairDefinition) throws ModelDriverException {
        String value = javaAnnotationToken.getLiteralValue(valuePairDefinition.getName());
        AnnotationDefinition annotationDefinition = valuePairDefinition.getAnnotationDefinition();
        Object result = null;
        if (value == null) {
            return null;
        }
        if (annotationDefinition == null) {
            return value;
        }
        if (valuePairDefinition.isArray()) {
            AnnotationSource[] javaAnnotationTokenValueArray = javaAnnotationToken.getAnnotationArrayValue(valuePairDefinition.getName());
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            if (javaAnnotationTokenValueArray != null) {
                for (int i = 0; i < javaAnnotationTokenValueArray.length; ++i) {
                    Annotation annotation = this.buildAnnotation(annotationDefinition, javaAnnotationTokenValueArray[i]);
                    if (annotation == null) continue;
                    annotationList.add(annotation);
                }
            }
            result = annotationList.size() > 0 ? annotationList : null;
        } else {
            AnnotationSource javaAnnotationTokenValue = javaAnnotationToken.getAnnotationValue(valuePairDefinition.getName());
            if (javaAnnotationTokenValue != null) {
                result = this.buildAnnotation(annotationDefinition, javaAnnotationTokenValue);
            }
        }
        return result;
    }

    private Object parsePrimitiveValue(String value, String className) {
        if (NamingUtils.isByteId(className)) {
            return this.parseByteValue(value, className);
        }
        if (NamingUtils.isCharId(className)) {
            return this.parseCharValue(value, className);
        }
        return NamingUtils.parsePrimitiveValue(className, value);
    }

    private List<Object> parsePrimitiveArrayValue(String value, String className, AnnotationValuePairDefinition valuePairDefinition) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (!(value = value.trim()).startsWith("{") || !value.endsWith("}")) {
            return values;
        }
        if (DriverUtils.isEmptyArray(value)) {
            return values;
        }
        value = PortableStringUtils.removeLastChar(PortableStringUtils.removeFirstChar(value, '{'), '}');
        String[] primitiveValues = value.split(",");
        for (int i = 0; i < primitiveValues.length; ++i) {
            Object primitiveValue = this.parsePrimitiveValue(primitiveValues[i], className);
            values.add(primitiveValue);
        }
        return values;
    }

    private Object parseByteValue(String value, String className) {
        String regex = "(\\s)*\\((\\s)*byte(\\s)*\\)(\\s)*";
        Pattern pattern = Pattern.compile(regex);
        String[] splits = pattern.split(value);
        Object result = null;
        try {
            result = splits.length == 0 ? NamingUtils.parsePrimitiveValue(className, value) : (splits.length == 1 ? NamingUtils.parsePrimitiveValue(className, splits[0]) : (splits.length == 2 ? NamingUtils.parsePrimitiveValue(className, splits[1]) : NamingUtils.parsePrimitiveValue(className, value)));
        }
        catch (NumberFormatException e) {
            result = value;
        }
        return result;
    }

    private Object parseCharValue(String value, String className) {
        String unquotedValue = StringEscapeUtils.unquoteSingle(value);
        return NamingUtils.parsePrimitiveValue(className, unquotedValue);
    }

    private Object parseEnumValue(String value, AnnotationValuePairDefinition valuePairDefinition) {
        String[] enumValues = valuePairDefinition.enumValues();
        String result = value;
        if (value != null && enumValues != null) {
            for (int i = 0; i < enumValues.length; ++i) {
                if (!value.endsWith(enumValues[i])) continue;
                result = enumValues[i];
                break;
            }
        }
        return result;
    }

    private List<Object> parseEnumArrayValue(String value, AnnotationValuePairDefinition valuePairDefinition) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (!(value = value.trim()).startsWith("{") || !value.endsWith("}")) {
            return values;
        }
        if (DriverUtils.isEmptyArray(value)) {
            return values;
        }
        value = PortableStringUtils.removeLastChar(PortableStringUtils.removeFirstChar(value, '{'), '}');
        String[] enumValues = value.split(",");
        for (int i = 0; i < enumValues.length; ++i) {
            Object enumValue = this.parseEnumValue(enumValues[i], valuePairDefinition);
            values.add(enumValue);
        }
        return values;
    }

    private List<Object> parseClassArrayValue(String value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (!(value = value.trim()).startsWith("{") || !value.endsWith("}")) {
            return values;
        }
        if (DriverUtils.isEmptyArray(value)) {
            return values;
        }
        value = PortableStringUtils.removeLastChar(PortableStringUtils.removeFirstChar(value, '{'), '}');
        String[] classValues = value.split(",");
        for (int i = 0; i < classValues.length; ++i) {
            String classValue = this.parseClassValue(classValues[i]);
            if (classValue == null) continue;
            values.add(classValue);
        }
        return values;
    }

    private String parseClassValue(String classValue) {
        return classValue != null ? classValue.trim() : null;
    }

    private boolean isValidClassValue(String value) {
        String classValue = value != null ? value.trim() : value;
        return classValue != null && classValue.length() > ".class".length() && classValue.endsWith(".class");
    }

    private String parseLiteralValue(String literalValue) {
        return literalValue;
    }
}

