/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.datamodel.rule.ActionFieldList;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.BRLColumnSubHeaderBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.SubHeaderBuilder;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.ColumnContext;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.FromTo;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.ValuePlaceHolder;

public class BRLColumnSubHeaderBuilderByPatterns
implements BRLColumnSubHeaderBuilder {
    private SubHeaderBuilder subHeaderBuilder;
    private ColumnContext columnContext;
    private GuidedDecisionTable52 dtable;

    public BRLColumnSubHeaderBuilderByPatterns(SubHeaderBuilder subHeaderBuilder, ColumnContext columnContext, GuidedDecisionTable52 dtable) {
        this.subHeaderBuilder = subHeaderBuilder;
        this.columnContext = columnContext;
        this.dtable = dtable;
    }

    @Override
    public void buildBrlActions(BRLActionColumn brlColumn) {
        Iterator definitionIterator = brlColumn.getDefinition().iterator();
        while (definitionIterator.hasNext()) {
            IAction iAction = (IAction)definitionIterator.next();
            Iterator<ValuePlaceHolder> valuesIterator = this.columnContext.getVariablesInOrderOfUse(iAction).iterator();
            String boundName = this.getBoundName(iAction);
            if (iAction instanceof ActionInsertFact) {
                ActionInsertFact actionInsertFact = (ActionInsertFact)iAction;
                this.subHeaderBuilder.getColumnContext().put((BRLColumn)brlColumn, FromTo.makePlaceHolder(this.dtable.getExpandedColumns().indexOf(brlColumn.getChildColumns().get(0)), this.subHeaderBuilder.getTargetColumnIndex()));
                boolean madeInsert = this.subHeaderBuilder.makeInsert(boundName, actionInsertFact.getFactType());
                if (madeInsert && this.fieldValuesLength((ActionFieldList)((ActionInsertFact)iAction)) != 0) {
                    this.subHeaderBuilder.incrementTargetIndex();
                }
            } else if (iAction instanceof ActionCallMethod && this.hasNoVariables(valuesIterator)) {
                this.subHeaderBuilder.addMethodCallWithoutParameters(brlColumn.getHeader(), (ActionCallMethod)iAction);
                this.updateColumnContext(brlColumn, (ActionCol52)brlColumn.getChildColumns().get(0));
            }
            while (valuesIterator.hasNext()) {
                ValuePlaceHolder value = valuesIterator.next();
                ActionCol52 childColumn = this.getChildActionColumn(value, brlColumn.getChildColumns());
                if (iAction instanceof ActionCallMethod) {
                    StringBuilder params = new StringBuilder();
                    int methodParameterCount = this.fieldValuesLength((ActionFieldList)((ActionCallMethod)iAction));
                    if (methodParameterCount == 1) {
                        params.append(this.wrapParameter(childColumn, "$param"));
                    } else if (valuesIterator.hasNext()) {
                        if (this.isThereJustOneVariableInParameters(((ActionCallMethod)iAction).getFieldValues())) {
                            params.append(this.wrapParameter(childColumn, "$param"));
                        } else {
                            params.append(this.wrapParameter(childColumn, "$1"));
                        }
                        block6: for (int i = 1; i < methodParameterCount; ++i) {
                            ValuePlaceHolder next = valuesIterator.next();
                            params.append(", ");
                            switch (next.getType()) {
                                case VARIABLE: {
                                    params.append(this.wrapParameter(childColumn, "$" + (i + 1)));
                                    this.updateColumnContext(brlColumn, this.getChildActionColumn(next, brlColumn.getChildColumns()));
                                    continue block6;
                                }
                                case VALUE: {
                                    params.append(next.getValue());
                                }
                            }
                        }
                    }
                    this.subHeaderBuilder.addMethodCallWithParameters(brlColumn.getHeader(), (ActionCallMethod)iAction, params.toString());
                    this.updateColumnContext(brlColumn, childColumn);
                    if (!valuesIterator.hasNext()) continue;
                    this.subHeaderBuilder.incrementTargetIndex();
                    continue;
                }
                if (!(childColumn instanceof BRLActionVariableColumn)) continue;
                this.addBRLActionVariableColumn(brlColumn, boundName, (BRLActionVariableColumn)childColumn);
                this.updateColumnContext(brlColumn, childColumn);
                if (!valuesIterator.hasNext()) continue;
                this.subHeaderBuilder.incrementTargetIndex();
            }
            if (!definitionIterator.hasNext()) continue;
            this.subHeaderBuilder.incrementTargetIndex();
        }
    }

    private int fieldValuesLength(ActionFieldList action) {
        if (action.getFieldValues() != null) {
            return action.getFieldValues().length;
        }
        return 0;
    }

    private String wrapParameter(ActionCol52 childColumn, String var) {
        if (childColumn instanceof BRLActionVariableColumn) {
            return this.subHeaderBuilder.getRHSParamWithWrapper(((BRLActionVariableColumn)childColumn).getFieldType(), var);
        }
        return var;
    }

    private boolean isThereJustOneVariableInParameters(ActionFieldValue[] actionFieldValues) {
        if (actionFieldValues == null) {
            return false;
        }
        boolean result = false;
        for (ActionFieldValue actionFieldValue : actionFieldValues) {
            if (actionFieldValue.getNature() != 7) continue;
            if (result) {
                return false;
            }
            result = true;
        }
        return result;
    }

    private boolean hasNoVariables(Iterator<ValuePlaceHolder> variablesIterator) {
        return !variablesIterator.hasNext();
    }

    public void addBRLActionVariableColumn(BRLActionColumn brlColumn, String boundName, BRLActionVariableColumn childColumn) {
        this.subHeaderBuilder.addBRLActionVariableColumn(brlColumn.getHeader(), boundName, childColumn.getFactType(), childColumn.getFactField(), "");
    }

    public void addInsertColumn(BRLActionColumn brlColumn, BRLActionVariableColumn childColumn) {
        this.subHeaderBuilder.getColumnContext().put((BRLColumn)brlColumn, FromTo.makePlaceHolder(this.dtable.getExpandedColumns().indexOf(childColumn), this.subHeaderBuilder.getTargetColumnIndex() - 1));
    }

    private String getBoundName(IAction iAction) {
        if (iAction instanceof ActionInsertFact && StringUtils.isNotEmpty((CharSequence)((ActionInsertFact)iAction).getBoundName())) {
            return ((ActionInsertFact)iAction).getBoundName();
        }
        if (iAction instanceof ActionSetField && StringUtils.isNotEmpty((CharSequence)((ActionSetField)iAction).getVariable())) {
            return ((ActionSetField)iAction).getVariable();
        }
        return this.columnContext.getNextFreeColumnFactName();
    }

    @Override
    public void buildBrlConditions(BRLConditionColumn brlColumn) {
        Iterator<String> variablesIterator = this.columnContext.getVariablesInOrderOfUse(brlColumn).iterator();
        while (variablesIterator.hasNext()) {
            ConditionCol52 childColumn = this.getChildConditionColumn(variablesIterator.next(), brlColumn.getChildColumns());
            this.subHeaderBuilder.addCondition(childColumn);
            this.updateColumnContext(brlColumn, childColumn);
            if (!variablesIterator.hasNext()) continue;
            this.subHeaderBuilder.incrementTargetIndex();
        }
    }

    private ActionCol52 getChildActionColumn(ValuePlaceHolder value, List<BRLActionVariableColumn> childColumns) {
        for (BRLActionVariableColumn childColumn : childColumns) {
            if (!Objects.equals(childColumn.getVarName(), value.getValue())) continue;
            return childColumn;
        }
        throw new IllegalArgumentException("Found a variable for a column that does not exist");
    }

    private ConditionCol52 getChildConditionColumn(String varName, List<BRLConditionVariableColumn> childColumns) {
        for (BRLConditionVariableColumn childColumn : childColumns) {
            if (!Objects.equals(childColumn.getVarName(), varName)) continue;
            return childColumn;
        }
        throw new IllegalArgumentException("Found a variable for a column that does not exist");
    }

    public void updateColumnContext(BRLConditionColumn brlColumn, ConditionCol52 childColumn) {
        this.subHeaderBuilder.getColumnContext().put((BRLColumn)brlColumn, FromTo.makeFromTo(this.dtable.getExpandedColumns().indexOf(childColumn), this.subHeaderBuilder.getTargetColumnIndex()));
    }

    public void updateColumnContext(BRLActionColumn brlColumn, ActionCol52 childColumn) {
        this.updateColumnContext(brlColumn, this.dtable.getExpandedColumns().indexOf(childColumn));
    }

    public void updateColumnContext(BRLActionColumn brlColumn, int from) {
        this.subHeaderBuilder.getColumnContext().put((BRLColumn)brlColumn, FromTo.makeFromTo(from, this.subHeaderBuilder.getTargetColumnIndex()));
    }
}

