/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.impl;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceProviderFactory;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceSettings;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverProvider;
import org.kie.workbench.common.screens.datasource.management.util.ServiceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DataSourceProviderFactoryImpl
implements DataSourceProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceProviderFactoryImpl.class);
    private static final String DATASOURCE_SERVICE = "datasource.management.DataSourceProvider";
    private static final String DRIVER_SERVICE = "datasource.management.DriverProvider";
    @Inject
    private BeanManager beanManager;
    private DataSourceProvider dataSourceProvider;
    private DriverProvider driverService;

    @PostConstruct
    public void init() {
        block13: {
            String serviceName;
            Properties properties;
            block12: {
                properties = DataSourceSettings.getInstance().getProperties();
                serviceName = ServiceUtil.getManagedProperty(properties, DATASOURCE_SERVICE);
                if (!ServiceUtil.isEmpty(serviceName)) {
                    try {
                        this.dataSourceProvider = (DataSourceProvider)ServiceUtil.getManagedBean(this.beanManager, serviceName);
                        if (this.dataSourceProvider == null) {
                            logger.error("It was not possible to get the reference to the data sources service: " + serviceName + ". Data source services won't be available.");
                            break block12;
                        }
                        this.dataSourceProvider.loadConfig(properties);
                    }
                    catch (Exception e) {
                        logger.error("An error was produced during: " + serviceName + " initialization.", (Throwable)e);
                    }
                } else {
                    logger.warn("Data source serviceName: datasource.management.DataSourceProvider property was not properly configured. Data source services won't be available.");
                }
            }
            serviceName = ServiceUtil.getManagedProperty(properties, DRIVER_SERVICE);
            if (!ServiceUtil.isEmpty(serviceName)) {
                try {
                    this.driverService = (DriverProvider)ServiceUtil.getManagedBean(this.beanManager, serviceName);
                    if (this.driverService == null) {
                        logger.error("It was not possible to get reference to the drivers service: " + serviceName + ". Drivers services won't be available.");
                        break block13;
                    }
                    this.driverService.loadConfig(properties);
                }
                catch (Exception e) {
                    logger.error("An error was produced during: " + serviceName + " initialization.", (Throwable)e);
                }
            } else {
                logger.warn("Drivers serviceName: datasource.management.DriverProvider property was not properly configured. Drivers services won't be available.");
            }
        }
        if (this.dataSourceProvider != null) {
            logger.debug("Data source service was properly initialized.");
        }
        if (this.driverService != null) {
            logger.debug("Drivers service was properly initialized.");
        }
    }

    @Override
    public DataSourceProvider getDataSourceProvider() {
        return this.dataSourceProvider;
    }

    @Override
    public DriverProvider getDriverProvider() {
        return this.driverService;
    }
}

