/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.artifacts;

import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.TextAnnotation;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.NodeConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.DataObjectPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TextAnnotationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.DataObject;
import org.kie.workbench.common.stunner.bpmn.definition.property.artifacts.DataObjectType;
import org.kie.workbench.common.stunner.bpmn.definition.property.artifacts.DataObjectTypeValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.AdvancedData;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class ArtifactsConverter
implements NodeConverter<FlowElement> {
    private final TypedFactoryManager typedFactoryManager;
    private PropertyReaderFactory propertyReaderFactory;

    public ArtifactsConverter(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory) {
        this.typedFactoryManager = typedFactoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    @Override
    public Result<BpmnNode> convert(FlowElement element) {
        return Match.of(FlowElement.class, BpmnNode.class).when(TextAnnotation.class, this::toTextAnnotation).when(DataObjectReference.class, this::toDataObject).apply(element);
    }

    private BpmnNode toTextAnnotation(TextAnnotation element) {
        TextAnnotationPropertyReader p = this.propertyReaderFactory.of(element);
        Node node = this.typedFactoryManager.newNode(element.getId(), org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation.class);
        org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation definition = (org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation)((View)node.getContent()).getDefinition();
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setAdvancedData(new AdvancedData(p.getMetaDataAttributes()));
        return BpmnNode.of(node, p);
    }

    private BpmnNode toDataObject(DataObjectReference element) {
        DataObjectPropertyReader p = this.propertyReaderFactory.of(element);
        Node node = this.typedFactoryManager.newNode(element.getId(), DataObject.class);
        DataObject definition = (DataObject)((View)node.getContent()).getDefinition();
        definition.setName(new Name(StringUtils.revertIllegalCharsAttribute((String)p.getName())));
        definition.setType(new DataObjectType(new DataObjectTypeValue(p.getType())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        definition.setAdvancedData(new AdvancedData(p.getMetaDataAttributes()));
        return BpmnNode.of(node, p);
    }
}

