/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.Process;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.ResultComposer;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.ProcessConverterDelegate;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.DefinitionsPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseFileVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseIdPrefix;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.BaseDiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.BaseProcessData;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.BaseRootProcessAdvancedData;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public abstract class BaseRootProcessConverter<D extends BPMNDiagram<S, P, F>, S extends BaseDiagramSet, P extends BaseProcessData, F extends BaseRootProcessAdvancedData> {
    final ProcessConverterDelegate delegate;

    public BaseRootProcessConverter(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory, DefinitionResolver definitionResolver, BaseConverterFactory factory) {
        this.delegate = new ProcessConverterDelegate(typedFactoryManager, propertyReaderFactory, definitionResolver, factory);
    }

    public Result<BpmnNode> convertProcess() {
        Process process = this.delegate.definitionResolver.getProcess();
        String definitionsId = this.delegate.definitionResolver.getDefinitions().getId();
        BpmnNode processRoot = this.convertProcessNode(definitionsId, process);
        Result<Map<String, BpmnNode>> nodesResult = this.delegate.convertChildNodes(processRoot, process.getFlowElements(), process.getLaneSets());
        Map<String, BpmnNode> nodes = nodesResult.value();
        Result<Boolean> edgesResult = this.delegate.convertEdges(processRoot, Stream.concat(process.getFlowElements().stream(), process.getArtifacts().stream()).collect(Collectors.toList()), nodes);
        Result<BpmnNode> postConvertResult = this.delegate.postConvert(processRoot);
        return ResultComposer.compose(processRoot, nodesResult, edgesResult, postConvertResult);
    }

    private BpmnNode convertProcessNode(String id, Process process) {
        Node<View<D>, Edge> diagramNode = this.createNode(id);
        BPMNDiagram definition = (BPMNDiagram)((View)diagramNode.getContent()).getDefinition();
        DefinitionsPropertyReader d = this.delegate.propertyReaderFactory.of(this.delegate.definitionResolver.getDefinitions());
        ProcessPropertyReader p = this.delegate.propertyReaderFactory.of(process);
        definition.setDiagramSet(this.createDiagramSet(process, p, d));
        definition.setCaseManagementSet(new CaseManagementSet(new CaseIdPrefix(p.getCaseIdPrefix()), new CaseRoles(p.getCaseRoles()), new CaseFileVariables(p.getCaseFileVariables())));
        definition.setProcessData(this.createProcessData(p.getProcessVariables()));
        definition.setAdvancedData(this.createAdvancedData(p.getGlobalVariables(), p.getMetaDataAttributes()));
        ((View)diagramNode.getContent()).setBounds(p.getBounds());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(diagramNode, p);
    }

    protected abstract Node<View<D>, Edge> createNode(String var1);

    protected abstract S createDiagramSet(Process var1, ProcessPropertyReader var2, DefinitionsPropertyReader var3);

    protected abstract P createProcessData(String var1);

    protected abstract F createAdvancedData(String var1, String var2);
}

