/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.lucene.BytesRefs;

public final class Uid {
    public static final char DELIMITER = '#';
    public static final byte DELIMITER_BYTE = 35;
    private final String type;
    private final String id;

    public Uid(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Uid uid = (Uid)o;
        if (this.id != null ? !this.id.equals(uid.id) : uid.id != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(uid.type) : uid.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Uid.createUid(this.type, this.id);
    }

    public BytesRef toBytesRef() {
        return Uid.createUidAsBytes(this.type, this.id);
    }

    public static Uid createUid(String uid) {
        int delimiterIndex = uid.indexOf(35);
        return new Uid(uid.substring(0, delimiterIndex), uid.substring(delimiterIndex + 1));
    }

    public static BytesRef createUidAsBytes(String type, String id) {
        return Uid.createUidAsBytes(new BytesRef((CharSequence)type), new BytesRef((CharSequence)id));
    }

    public static BytesRef createUidAsBytes(String type, BytesRef id) {
        return Uid.createUidAsBytes(new BytesRef((CharSequence)type), id);
    }

    public static BytesRef createUidAsBytes(BytesRef type, BytesRef id) {
        BytesRef ref = new BytesRef(type.length + 1 + id.length);
        System.arraycopy(type.bytes, type.offset, ref.bytes, 0, type.length);
        ref.offset = type.length;
        ref.bytes[ref.offset++] = 35;
        System.arraycopy(id.bytes, id.offset, ref.bytes, ref.offset, id.length);
        ref.offset = 0;
        ref.length = ref.bytes.length;
        return ref;
    }

    public static BytesRef[] createUidsForTypesAndId(Collection<String> types, Object id) {
        return Uid.createUidsForTypesAndIds(types, Collections.singletonList(id));
    }

    public static BytesRef[] createUidsForTypesAndIds(Collection<String> types, Collection<?> ids) {
        BytesRef[] uids = new BytesRef[types.size() * ids.size()];
        BytesRefBuilder typeBytes = new BytesRefBuilder();
        BytesRefBuilder idBytes = new BytesRefBuilder();
        int index = 0;
        for (String type : types) {
            typeBytes.copyChars((CharSequence)type);
            for (Object id : ids) {
                uids[index++] = Uid.createUidAsBytes(typeBytes.get(), BytesRefs.toBytesRef(id, idBytes));
            }
        }
        return uids;
    }

    public static String createUid(String type, String id) {
        return type + '#' + id;
    }
}

