/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DeregisterNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RemoveChildrenCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessorImpl;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessorImpl;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.graph.util.SafeDeleteNodeProcessor;

@Portable
public class SafeDeleteNodeCommand
extends AbstractGraphCompositeCommand {
    private final String candidateUUID;
    private final Options options;
    private transient Node<?, Edge> node;
    private transient Optional<SafeDeleteNodeCommandCallback> safeDeleteCallback;

    public SafeDeleteNodeCommand(@MapsTo(value="candidateUUID") String candidateUUID, @MapsTo(value="options") Options options) {
        this.candidateUUID = (String)PortablePreconditions.checkNotNull((String)"candidateUUID", (Object)candidateUUID);
        this.options = (Options)PortablePreconditions.checkNotNull((String)"options", (Object)options);
        this.safeDeleteCallback = Optional.empty();
    }

    public SafeDeleteNodeCommand(Node<?, Edge> node) {
        this(node, Options.defaults());
        this.node = node;
    }

    public SafeDeleteNodeCommand(Node<?, Edge> node, Options options) {
        this(node.getUUID(), options);
        this.node = node;
    }

    public SafeDeleteNodeCommand(Node<?, Edge> node, SafeDeleteNodeCommandCallback safeDeleteCallback, Options options) {
        this(node, options);
        this.safeDeleteCallback = Optional.ofNullable(safeDeleteCallback);
    }

    public Optional<SafeDeleteNodeCommandCallback> getSafeDeleteCallback() {
        return this.safeDeleteCallback;
    }

    public boolean shouldKeepChildren(Node<Definition<?>, Edge> candidate) {
        return false;
    }

    protected SafeDeleteNodeCommand initialize(GraphCommandExecutionContext context) {
        super.initialize(context);
        Graph<?, Node> graph = this.getGraph(context);
        Node<? extends Definition<?>, Edge> candidate = this.getCandidate(context);
        this.deleteNode(graph, candidate);
        return this;
    }

    private void deleteNode(Graph<?, Node> graph, Node<Definition<?>, Edge> candidate) {
        new SafeDeleteNodeProcessor(new ChildrenTraverseProcessorImpl(new TreeWalkTraverseProcessorImpl()), graph, candidate, this.shouldKeepChildren(candidate), new TreeWalkTraverseProcessorImpl(), this.getGraphsProvider()).run(this.createDeleteNodeAndChildrenCallback(candidate));
    }

    public GraphsProvider getGraphsProvider() {
        return null;
    }

    protected DeregisterNodeCommand createDeregisterNodeCommand(Node node) {
        return new DeregisterNodeCommand(node);
    }

    private SafeDeleteNodeProcessor.Callback createDeleteNodeAndChildrenCallback(final Node<Definition<?>, Edge> candidate) {
        return new SafeDeleteNodeProcessor.Callback(){
            private final Set<String> processedConnectors = new HashSet<String>();

            @Override
            public void deleteCandidateConnector(Edge<? extends View<?>, Node> edge) {
                if (!this.processedConnectors.contains(edge.getUUID())) {
                    this.processCandidateConnectors();
                }
            }

            @Override
            public boolean deleteConnector(Edge<? extends View<?>, Node> edge) {
                return this.doDeleteConnector(edge);
            }

            @Override
            public void removeChild(Element<?> parent, Node<?, Edge> candidate2) {
                if (SafeDeleteNodeCommand.this.shouldKeepChildren(candidate2)) {
                    SafeDeleteNodeCommand.this.createChangeParentCommands(parent, candidate2);
                }
                SafeDeleteNodeCommand.this.addCommand(SafeDeleteNodeCommand.this.createRemoveChildCommand(parent, candidate2));
                SafeDeleteNodeCommand.this.safeDeleteCallback.ifPresent(c -> c.removeChild(parent, candidate2));
            }

            @Override
            public void removeDock(Node<?, Edge> parent, Node<?, Edge> candidate2) {
                SafeDeleteNodeCommand.this.addCommand(new UnDockNodeCommand(parent, candidate2));
                SafeDeleteNodeCommand.this.safeDeleteCallback.ifPresent(c -> c.removeDock(parent, candidate2));
            }

            @Override
            public void deleteCandidateNode(Node<?, Edge> node) {
                this.deleteNode(node);
            }

            @Override
            public boolean deleteNode(Node<?, Edge> node) {
                if (!SafeDeleteNodeCommand.this.isElementExcluded(node)) {
                    SafeDeleteNodeCommand.this.addCommand(SafeDeleteNodeCommand.this.createDeregisterNodeCommand(node));
                    SafeDeleteNodeCommand.this.safeDeleteCallback.ifPresent(c -> c.deleteNode(node));
                    return true;
                }
                return false;
            }

            private void processCandidateConnectors() {
                if (SafeDeleteNodeCommand.this.options.isShortcutCandidateConnectors() && SafeDeleteNodeCommand.hasSingleIncomingEdge().and(SafeDeleteNodeCommand.hasSingleOutgoingEdge()).test(candidate)) {
                    Edge in = (Edge)SafeDeleteNodeCommand.getViewConnector().apply(candidate.getInEdges());
                    Edge out = (Edge)SafeDeleteNodeCommand.getViewConnector().apply(candidate.getOutEdges());
                    this.shortcut(in, out);
                } else {
                    Stream.concat(candidate.getInEdges().stream(), candidate.getOutEdges().stream()).filter(e -> e.getContent() instanceof ViewConnector).forEach(this::deleteConnector);
                }
            }

            private void shortcut(Edge<? extends ViewConnector<?>, Node> in, Edge<? extends ViewConnector<?>, Node> out) {
                ViewConnector outContent = (ViewConnector)out.getContent();
                Node targetNode = out.getTargetNode();
                SafeDeleteNodeCommand.this.addCommand(SafeDeleteNodeCommand.this.getDeleteConnectorCommand(out));
                SafeDeleteNodeCommand.this.safeDeleteCallback.ifPresent(c -> c.deleteCandidateConnector(out));
                SafeDeleteNodeCommand.this.addCommand(new SetConnectionTargetNodeCommand(targetNode, in, (Connection)outContent.getTargetConnection().orElse(null)));
                SafeDeleteNodeCommand.this.safeDeleteCallback.ifPresent(c -> c.setEdgeTargetNode(targetNode, in));
                this.processedConnectors.add(in.getUUID());
                this.processedConnectors.add(out.getUUID());
            }

            private boolean doDeleteConnector(Edge<? extends View<?>, Node> edge) {
                if (!SafeDeleteNodeCommand.this.isElementExcluded(edge) && !this.processedConnectors.contains(edge.getUUID())) {
                    SafeDeleteNodeCommand.this.addCommand(SafeDeleteNodeCommand.this.getDeleteConnectorCommand(edge));
                    SafeDeleteNodeCommand.this.safeDeleteCallback.ifPresent(c -> c.deleteConnector(edge));
                    this.processedConnectors.add(edge.getUUID());
                    return true;
                }
                return false;
            }
        };
    }

    protected DeleteConnectorCommand getDeleteConnectorCommand(Edge<? extends View<?>, Node> edge) {
        return new DeleteConnectorCommand(edge);
    }

    void createChangeParentCommands(Element<?> canvas, Node<?, Edge> candidate) {
        List<Node> childNodes = GraphUtils.getChildNodes(candidate);
        for (Node n : childNodes) {
            this.safeDeleteCallback.ifPresent(c -> c.moveChildToCanvasRoot((Element<?>)canvas.asNode(), (Node<?, Edge>)n));
        }
    }

    protected AbstractGraphCommand createRemoveChildCommand(Element<?> parent, Node<?, Edge> candidate) {
        return new RemoveChildrenCommand((Node)parent, candidate);
    }

    private boolean isElementExcluded(Element<?> e) {
        return !this.options.getExclusions().isEmpty() && this.options.getExclusions().contains(e.getUUID());
    }

    @Override
    protected boolean delegateRulesContextToChildren() {
        return true;
    }

    private Node<? extends Definition<?>, Edge> getCandidate(GraphCommandExecutionContext context) {
        if (null == this.node) {
            this.node = this.checkNodeNotNull(context, this.candidateUUID);
        }
        return this.node;
    }

    public Node<?, Edge> getNode() {
        return this.node;
    }

    public Options getOptions() {
        return this.options;
    }

    private static Predicate<Node<Definition<?>, Edge>> hasSingleIncomingEdge() {
        return node -> 1L == SafeDeleteNodeCommand.countViewConnectors().apply(node.getInEdges());
    }

    private static Predicate<Node<Definition<?>, Edge>> hasSingleOutgoingEdge() {
        return node -> 1L == SafeDeleteNodeCommand.countViewConnectors().apply(node.getOutEdges());
    }

    private static Function<List<Edge>, Long> countViewConnectors() {
        return edges -> edges.stream().filter(e -> e.getContent() instanceof ViewConnector).count();
    }

    private static Function<List<Edge>, Edge> getViewConnector() {
        return edges -> edges.stream().filter(e -> e.getContent() instanceof ViewConnector).findAny().get();
    }

    @Override
    public String toString() {
        return "SafeDeleteNodeCommand [candidate=" + this.candidateUUID + "]";
    }

    @NonPortable
    public static interface SafeDeleteNodeCommandCallback
    extends SafeDeleteNodeProcessor.Callback {
        public void setEdgeTargetNode(Node<? extends View<?>, Edge> var1, Edge<? extends ViewConnector<?>, Node> var2);
    }

    @Portable
    public static final class Options {
        private final boolean shortcutCandidateConnectors;
        private final Set<String> exclusions;

        public static Options defaults() {
            return new Options(true, new HashSet<String>());
        }

        public static Options doNotShortcutConnectors() {
            return new Options(false, new HashSet<String>());
        }

        public static Options exclude(Set<String> ids) {
            return new Options(false, ids);
        }

        public Options(@MapsTo(value="shortcutCandidateConnectors") boolean shortcutCandidateConnectors, @MapsTo(value="exclusions") Set<String> exclusions) {
            this.shortcutCandidateConnectors = shortcutCandidateConnectors;
            this.exclusions = exclusions;
        }

        public boolean isShortcutCandidateConnectors() {
            return this.shortcutCandidateConnectors;
        }

        public Set<String> getExclusions() {
            return this.exclusions;
        }
    }
}

