/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.registry.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kie.workbench.common.stunner.core.registry.DynamicRegistry;
import org.kie.workbench.common.stunner.core.registry.impl.KeyProvider;

class ListRegistry<T>
implements DynamicRegistry<T> {
    private final KeyProvider<T> keyProvider;
    private final List<T> items;

    public ListRegistry(KeyProvider<T> keyProvider, List<T> items) {
        this.keyProvider = keyProvider;
        this.items = items;
    }

    public void add(int pos, T item) {
        this.items.add(pos, item);
    }

    public void register(T item) {
        this.items.add(item);
    }

    public boolean remove(T item) {
        return this.items.remove(item);
    }

    public boolean contains(T item) {
        return this.items.contains(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Collection<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public T getItemByKey(String id) {
        if (null != id) {
            for (T item : this.items) {
                String itemId = this.getItemKey(item);
                if (!id.equals(itemId)) continue;
                return item;
            }
        }
        return null;
    }

    public void clear() {
        this.items.clear();
    }

    public int indexOf(T item) {
        return this.items.indexOf(item);
    }

    private String getItemKey(T item) {
        return this.keyProvider.getKey(item);
    }
}

