/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.ConnectionContext;
import org.kie.workbench.common.stunner.core.rule.impl.CanConnect;
import org.kie.workbench.common.stunner.core.rule.violations.ConnectionRuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.uberfire.commons.data.Pair;

@ApplicationScoped
public class ConnectionEvaluationHandler
implements RuleEvaluationHandler<CanConnect, ConnectionContext> {
    public Class<CanConnect> getRuleType() {
        return CanConnect.class;
    }

    public Class<ConnectionContext> getContextType() {
        return ConnectionContext.class;
    }

    public boolean accepts(CanConnect rule, ConnectionContext context) {
        return rule.getRole().equals(context.getConnectorRole());
    }

    public RuleViolations evaluate(CanConnect rule, ConnectionContext context) {
        List<CanConnect.PermittedConnection> permittedConnections = rule.getPermittedConnections();
        String currentConnectorRole = context.getConnectorRole();
        Set incomingLabels = context.getTargetRoles().orElse(Collections.emptySet());
        Set outgoingLabels = context.getSourceRoles().orElse(Collections.emptySet());
        DefaultRuleViolations results = new DefaultRuleViolations();
        LinkedHashSet<Pair<String, String>> couples = new LinkedHashSet<Pair<String, String>>();
        for (CanConnect.PermittedConnection pc : permittedConnections) {
            boolean endMatch;
            boolean startMatch = outgoingLabels.contains(pc.getStartRole());
            boolean bl = endMatch = startMatch && incomingLabels.contains(pc.getEndRole());
            if (endMatch) {
                return results;
            }
            couples.add((Pair<String, String>)new Pair((Object)pc.getStartRole(), (Object)pc.getEndRole()));
        }
        results.addViolation(new ConnectionRuleViolation(currentConnectorRole, this.serializeAllowedConnections(couples)));
        return results;
    }

    private Set<String> serializeAllowedConnections(Set<Pair<String, String>> couples) {
        return couples.stream().map(p -> "{'" + (String)p.getK1() + "' ->'" + (String)p.getK2() + "'}").collect(Collectors.toSet());
    }
}

