/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.NodeDockingContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;
import org.kie.workbench.common.stunner.core.rule.handler.impl.DockingEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.handler.impl.GraphEvaluationHandlerUtils;
import org.kie.workbench.common.stunner.core.rule.impl.CanDock;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@ApplicationScoped
public class NodeDockingEvaluationHandler
implements RuleEvaluationHandler<CanDock, NodeDockingContext> {
    private final DockingEvaluationHandler dockingHandler;
    private final GraphEvaluationHandlerUtils evalUtils;

    protected NodeDockingEvaluationHandler() {
        this(null, null);
    }

    @Inject
    public NodeDockingEvaluationHandler(DefinitionManager definitionManager, DockingEvaluationHandler dockingHandler) {
        this.dockingHandler = dockingHandler;
        this.evalUtils = new GraphEvaluationHandlerUtils(definitionManager);
    }

    public Class<CanDock> getRuleType() {
        return CanDock.class;
    }

    public Class<NodeDockingContext> getContextType() {
        return NodeDockingContext.class;
    }

    public boolean accepts(CanDock rule, NodeDockingContext context) {
        Set<String> parentLabels = this.evalUtils.getLabels(context.getParent());
        return this.dockingHandler.accepts(rule, RuleEvaluationContextBuilder.DomainContexts.docking(parentLabels, Collections.emptySet()));
    }

    public RuleViolations evaluate(CanDock rule, NodeDockingContext context) {
        Node target = context.getCandidate();
        Set<String> parentLabels = this.evalUtils.getLabels(context.getParent());
        Set<String> candidateLabels = this.evalUtils.getLabels((Element<? extends Definition<?>>)target);
        DefaultRuleViolations result = new DefaultRuleViolations();
        result.addViolations(this.dockingHandler.evaluate(rule, RuleEvaluationContextBuilder.DomainContexts.docking(parentLabels, candidateLabels)));
        return GraphEvaluationHandlerUtils.addViolationsSourceUUID(target.getUUID(), result);
    }
}

