/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import com.github.javaparser.utils.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.PotentialOwner;
import org.eclipse.bpmn2.ResourceRole;
import org.eclipse.bpmn2.UserTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.UserTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.assignee.Actors;

public class UserTaskPropertyWriterTest {
    private FlatVariableScope variableScope;

    @Before
    public void before() {
        this.variableScope = new FlatVariableScope();
    }

    @Test
    public void startsFromUnderscore() {
        UserTask userTask = Factories.bpmn2.createUserTask();
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(userTask, (VariableScope)this.variableScope, new HashSet());
        Actors actor = new Actors();
        actor.setValue("startsFromUnderscore");
        userTaskPropertyWriter.setActors(actor);
        Assert.assertEquals((Object)"startsFromUnderscore", (Object)this.getActors((UserTask)userTask).get((int)0).a);
        Assert.assertTrue((boolean)((String)this.getActors((UserTask)userTask).get((int)0).b).startsWith("_"));
    }

    @Test
    public void testEmptyOutputSets() {
        UserTask userTask = Factories.bpmn2.createUserTask();
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(userTask, (VariableScope)this.variableScope, new HashSet());
        Assert.assertEquals((long)0L, (long)userTaskPropertyWriter.getIoSpecification().getOutputSets().size());
    }

    public List<Pair<String, String>> getActors(UserTask userTask) {
        List roles = userTask.getResources();
        ArrayList<Pair<String, String>> actors = new ArrayList<Pair<String, String>>();
        for (ResourceRole role : roles) {
            if (!(role instanceof PotentialOwner)) continue;
            FormalExpression fe = (FormalExpression)role.getResourceAssignmentExpression().getExpression();
            actors.add((Pair<String, String>)new Pair((Object)fe.getBody(), (Object)role.getId()));
        }
        return actors;
    }
}

