/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TestDefinitionsWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SequenceFlowPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SequenceFlowPropertyReaderTest {
    private static final String SCRIPT = "SCRIPT";
    private final String SEQ_ID = "SEQ_ID";
    private final String SOURCE_ID = "SOURCE_ID";
    private final String TARGET_ID = "TARGET_ID";

    @Test
    public void getConnectionsNoWaypoints() {
        TestDefinitionsWriter d = new TestDefinitionsWriter();
        PropertyReaderFactory factory = new PropertyReaderFactory(d.getDefinitionResolver());
        Bounds sourceBounds = this.boundsOf(10.0f, 10.0f, 50.0f, 50.0f);
        FlowNode source = d.mockNode("SOURCE_ID", sourceBounds);
        Bounds targetBounds = this.boundsOf(100.0f, 100.0f, 60.0f, 60.0f);
        FlowNode target = d.mockNode("TARGET_ID", targetBounds);
        List<Point> noWaypoints = Collections.emptyList();
        SequenceFlow el = d.sequenceFlowOf("SEQ_ID", source, target, noWaypoints);
        SequenceFlowPropertyReader p = factory.of(el);
        Connection sourceConnection = p.getSourceConnection();
        Assert.assertEquals((float)sourceBounds.getWidth(), (float)((float)sourceConnection.getLocation().getX()), (float)0.0f);
        Assert.assertEquals((float)(sourceBounds.getHeight() / 2.0f), (float)((float)sourceConnection.getLocation().getY()), (float)0.0f);
        Connection targetConnection = p.getTargetConnection();
        Assert.assertEquals((float)0.0f, (float)((float)targetConnection.getLocation().getX()), (float)0.0f);
        Assert.assertEquals((float)(targetBounds.getHeight() / 2.0f), (float)((float)targetConnection.getLocation().getY()), (float)0.0f);
    }

    @Test
    public void getConnectionsWithWaypoints() {
        TestDefinitionsWriter d = new TestDefinitionsWriter();
        PropertyReaderFactory factory = new PropertyReaderFactory(d.getDefinitionResolver());
        Bounds sourceBounds = this.boundsOf(10.0f, 10.0f, 50.0f, 50.0f);
        FlowNode source = d.mockNode("SOURCE_ID", sourceBounds);
        Bounds targetBounds = this.boundsOf(100.0f, 100.0f, 60.0f, 60.0f);
        FlowNode target = d.mockNode("TARGET_ID", targetBounds);
        Point sourcePoint = this.pointOf(10.0f, 20.0f);
        Point targetPoint = this.pointOf(100.0f, 120.0f);
        List<Point> waypoints = Arrays.asList(sourcePoint, targetPoint);
        SequenceFlow el = d.sequenceFlowOf("SEQ_ID", source, target, waypoints);
        SequenceFlowPropertyReader p = factory.of(el);
        Connection sourceConnection = p.getSourceConnection();
        Assert.assertEquals((float)(sourcePoint.getX() - sourceBounds.getX()), (float)((float)sourceConnection.getLocation().getX()), (float)0.0f);
        Assert.assertEquals((float)(sourcePoint.getY() - sourceBounds.getY()), (float)((float)sourceConnection.getLocation().getY()), (float)0.0f);
        Connection targetConnection = p.getTargetConnection();
        Assert.assertEquals((float)(targetPoint.getX() - targetBounds.getX()), (float)((float)targetConnection.getLocation().getX()), (float)0.0f);
        Assert.assertEquals((float)(targetPoint.getY() - targetBounds.getY()), (float)((float)targetConnection.getLocation().getY()), (float)0.0f);
    }

    @Test
    public void get1Waypoint() {
        TestDefinitionsWriter d = new TestDefinitionsWriter();
        PropertyReaderFactory factory = new PropertyReaderFactory(d.getDefinitionResolver());
        Bounds sourceBounds = this.boundsOf(10.0f, 10.0f, 50.0f, 50.0f);
        FlowNode source = d.mockNode("SOURCE_ID", sourceBounds);
        Bounds targetBounds = this.boundsOf(100.0f, 100.0f, 60.0f, 60.0f);
        FlowNode target = d.mockNode("TARGET_ID", targetBounds);
        Point sourcePoint = this.pointOf(10.0f, 20.0f);
        Point mid1 = this.pointOf(15.0f, 25.0f);
        Point targetPoint = this.pointOf(100.0f, 120.0f);
        List<Point> waypoints = Arrays.asList(sourcePoint, mid1, targetPoint);
        SequenceFlow el = d.sequenceFlowOf("SEQ_ID", source, target, waypoints);
        SequenceFlowPropertyReader p = factory.of(el);
        List controlPoints = p.getControlPoints();
        List<Point2D> expected = Collections.singletonList(Point2D.create((double)mid1.getX(), (double)mid1.getY()));
        Assert.assertEquals(expected, (Object)controlPoints);
    }

    @Test
    public void get2Waypoints() {
        TestDefinitionsWriter d = new TestDefinitionsWriter();
        PropertyReaderFactory factory = new PropertyReaderFactory(d.getDefinitionResolver());
        Bounds sourceBounds = this.boundsOf(10.0f, 10.0f, 50.0f, 50.0f);
        FlowNode source = d.mockNode("SOURCE_ID", sourceBounds);
        Bounds targetBounds = this.boundsOf(100.0f, 100.0f, 60.0f, 60.0f);
        FlowNode target = d.mockNode("TARGET_ID", targetBounds);
        Point sourcePoint = this.pointOf(10.0f, 20.0f);
        Point mid1 = this.pointOf(15.0f, 25.0f);
        Point mid2 = this.pointOf(20.0f, 30.0f);
        Point targetPoint = this.pointOf(100.0f, 120.0f);
        List<Point> waypoints = Arrays.asList(sourcePoint, mid1, mid2, targetPoint);
        SequenceFlow el = d.sequenceFlowOf("SEQ_ID", source, target, waypoints);
        SequenceFlowPropertyReader p = factory.of(el);
        List controlPoints = p.getControlPoints();
        List<Point2D> expected = Arrays.asList(Point2D.create((double)mid1.getX(), (double)mid1.getY()), Point2D.create((double)mid2.getX(), (double)mid2.getY()));
        Assert.assertEquals(expected, (Object)controlPoints);
    }

    private Point pointOf(float x, float y) {
        Point point = Factories.dc.createPoint();
        point.setX(x);
        point.setY(y);
        return point;
    }

    private Bounds boundsOf(float x, float y, float width, float height) {
        Bounds bounds = Factories.dc.createBounds();
        bounds.setX(x);
        bounds.setY(y);
        bounds.setWidth(width);
        bounds.setHeight(height);
        return bounds;
    }

    @Test
    public void testGetConditionExpressionWithFormalExpression() {
        for (Scripts.LANGUAGE language : Scripts.LANGUAGE.values()) {
            FormalExpression formalExpression = (FormalExpression)Mockito.mock(FormalExpression.class);
            Mockito.when((Object)formalExpression.getLanguage()).thenReturn((Object)language.format());
            Mockito.when((Object)formalExpression.getBody()).thenReturn((Object)SCRIPT);
            this.testGetConditionExpression(new ScriptTypeValue(language.language(), SCRIPT), formalExpression);
        }
    }

    @Test
    public void testGetConditionExpressionWithoutFormalExpression() {
        this.testGetConditionExpression(new ScriptTypeValue(Scripts.LANGUAGE.JAVA.language(), ""), null);
    }

    private void testGetConditionExpression(ScriptTypeValue expectedValue, FormalExpression formalExpression) {
        TestDefinitionsWriter d = new TestDefinitionsWriter();
        PropertyReaderFactory factory = new PropertyReaderFactory(d.getDefinitionResolver());
        SequenceFlow sequenceFlow = (SequenceFlow)Mockito.mock(SequenceFlow.class);
        SequenceFlowPropertyReader propertyReader = factory.of(sequenceFlow);
        Mockito.when((Object)sequenceFlow.getConditionExpression()).thenReturn((Object)formalExpression);
        Assert.assertEquals((Object)expectedValue, (Object)propertyReader.getConditionExpression());
    }
}

